// DispatchMessage.cpp: implementation of the CDispatchMessage class. 
// 
////////////////////////////////////////////////////////////////////// 
 
#include "../../Include/Comm/DispatchMessage.h" 
#include "../../Include/Base/StringToObjectCollection.h" 
#include "../../Include/Base/StringContainer.h" 
#include "../../Include/Base/ULongContainer.h" 
#include "../../Include/Base/ByteContainer.h" 
 
#ifdef linux 
  #include <stddef.h> 
  #include <string.h> 
  #include <stdio.h> 
#endif //linux 
     
#ifdef __SCO__ 
  #include <stddef.h> 
  #include <string.h> 
  #include <stdio.h> 
#endif // __SCO__ 
 
#ifdef __HPUX__ 
  #include <stddef.h> 
  #include <string.h> 
  #include <stdio.h> 
#endif // __HPUX__ 
 

////////////////////////////////////////////////////////////////////// 
// Construction/Destruction 
////////////////////////////////////////////////////////////////////// 
 
CDispatchMessage::CDispatchMessage(char *name) : CMessage (name) 
{ 
	m_szMessageType = NULL; 
    m_Values = new CStringToObjectCollection; 
    m_Lists = new CStringToObjectCollection; 
} 
 
CDispatchMessage::CDispatchMessage() : CMessage ("DispatchMessage") 
{ 
	m_szMessageType = NULL; 
    m_Values = new CStringToObjectCollection; 
    m_Lists = new CStringToObjectCollection; 
} 
 
CDispatchMessage::~CDispatchMessage() 
{ 
    ULONG32 position = 0; 
    ULONG32 positionList = 0; 
    CObject *object = NULL; 
    char key[256]; 
    CObject *objectList = NULL; 
    char keyList[256]; 
 
	// Delete message type 
	if (m_szMessageType != NULL) 
	{ 
		delete m_szMessageType; 
	} 
 
    // Delete all collection in Lists 
    object = m_Lists->GetFirst (&position,key,256); 
 
    while (object != NULL) 
    { 
    	objectList = ((CStringToObjectCollection *)object)->GetFirst (&positionList,keyList,256); 
    	while (objectList != NULL) 
    	{ 
    		delete objectList; 
    		objectList = ((CStringToObjectCollection *)object)->GetNext (&positionList,keyList,256); 
    	} 
    	delete object; 
    	object = m_Lists->GetNext (&position,key,256); 
    } 
 
    delete m_Lists; 
 
    // Delete all containers in Values 
    object = m_Values->GetFirst (&position,key,256); 
 
    while (object != NULL) 
    { 
    	delete object; 
    	object = m_Values->GetNext (&position,key,256); 
    } 
 
    delete m_Values; 
} 
 
void CDispatchMessage::SetMessageType (char *type) 
{ 
	if (type != NULL) 
	{ 
		if (strlen (type) < 65535) 
		{ 
			if (m_szMessageType != NULL) 
			{ 
				delete [] m_szMessageType; 
			} 
 
			m_szMessageType = new char [(strlen (type)) + 1]; 
			memset (m_szMessageType,0,(strlen (type)) + 1); 
			strncpy (m_szMessageType,type,(strlen (type)) + 1); 
		} 
	} 
} 
 
char *CDispatchMessage::GetMessageType (void) 
{ 
	return m_szMessageType; 
} 
 
void CDispatchMessage::AddValueForKey (char *key, char *value) 
{ 
    CStringContainer *container; 
 
    if (key != NULL && value != NULL) 
    { 
    	container = new CStringContainer; 
 
    	container->SetString (value); 
    	m_Values->Add (key,container); 
    } 
} 
 
void CDispatchMessage::AddValueForKey (char *key, unsigned long value) 
{ 
    CLongContainer *container; 
 
    if (key != NULL) 
    { 
    	container = new CLongContainer; 
 
    	container->SetULong (value); 
    	m_Values->Add (key,container); 
    } 
} 
 
void CDispatchMessage::AddValueForKey (char *key, BYTE *value, unsigned long valueLength) 
{ 
    CByteContainer *container; 
 
    if (key != NULL && value != NULL && valueLength != 0) 
    { 
    	container = new CByteContainer; 
 
    	container->SetBytes (value,valueLength); 
    	m_Values->Add (key,container); 
    } 
} 
 
BOOL CDispatchMessage::GetValueForKey (char *key, char *value, unsigned long valueLength) 
{ 
    CObject *container = NULL; 
 
    if (key == NULL || value == NULL || valueLength == 0) 
    { 
    	return FALSE; 
    } 
 
    container = m_Values->Lookup (key); 
 
    if (container == NULL) 
    { 
    	return FALSE; 
    } 
 
    // Check for the right name and type 
    if (!(strcmp (container->GetName(),"StringContainer") == 0  &&  
    	strcmp (container->GetType(),"Container") == 0)) 
    { 
    	// Not the right name and type 
    	return FALSE; 
    } 
 
    // Fill the value 
    if (((CStringContainer *)container)->GetString() == NULL) 
    { 
    	value[0] = '\0'; 
    } 
    else 
    { 
    	strncpy (value,((CStringContainer *)container)->GetString(),valueLength); 
    } 
 
    return TRUE; 
} 
 
BOOL CDispatchMessage::GetValueForKey (char *key, unsigned long *value) 
{ 
    CObject *container = NULL; 
 
    if (key == NULL || value == NULL) 
    { 
    	return FALSE; 
    } 
 
    container = m_Values->Lookup (key); 
 
    if (container == NULL) 
    { 
    	return FALSE; 
    } 
 
    // Check for the right name and type 
    if (!(strcmp (container->GetName(),"ULongContainer") == 0 && 
    	strcmp (container->GetType(),"Container") == 0)) 
    { 
    	// Not the right name and type 
    	return FALSE; 
    } 
 
    // Fill the value 
    *value = ((CLongContainer *)container)->GetULong(); 
 
    return TRUE; 
} 
 
BOOL CDispatchMessage::GetValueForKey (char *key, BYTE *value, unsigned long valueLength) 
{ 
    CObject *container = NULL; 
 
    if (key == NULL || value == NULL || valueLength == 0) 
    { 
    	return FALSE; 
    } 
 
    container = m_Values->Lookup (key); 
 
    if (container == NULL) 
    { 
    	return FALSE; 
    } 
 
    // Check for the right name and type 
    if (!(strcmp (container->GetName(),"ByteContainer") == 0  &&  
    	strcmp (container->GetType(),"Container") == 0)) 
    { 
    	// Not the right name and type 
    	return FALSE; 
    } 
 
    // Fill the value 
    if (((CByteContainer *)container)->GetBytes(value,valueLength) == FALSE) 
    { 
    	// value size to short 
    	return FALSE; 
    } 
 
    return TRUE; 
} 
 
unsigned long CDispatchMessage::GetLengthForKey (char *key) 
{ 
    CObject *container = NULL; 
 
    if (key == NULL) 
    { 
    	return 0; 
    } 
 
    container = m_Values->Lookup (key); 
 
    if (container == NULL) 
    { 
    	return 0; 
    } 
 
    // Check if it's a container 
    if (strcmp (container->GetType(),"Container") != 0) 
    { 
    	return 0; 
    } 
 
    // Check it's name 
    if (strcmp (container->GetName(),"StringContainer") == 0) 
    { 
  	    if (((CStringContainer *)container)->GetString() == NULL) 
  	    { 
  		    return 0; 
  	    } 
  	    else 
  	    { 
 	   	    size_t stringLength = strlen (((CStringContainer *)container)->GetString()); 
    		    return (unsigned long)stringLength; 
 	    } 
    } 
    else if (strcmp (container->GetName(),"ULongContainer") == 0) 
    { 
    	return sizeof (unsigned long); 
    } 
    else if (strcmp (container->GetName(),"ByteContainer") == 0) 
    { 
    	return ((CByteContainer *)container)->GetLength(); 
    } 
    else 
    { 
    	// Not known container 
    	return 0; 
    } 
 
    // Compiler happy 
#ifndef __SCO__
    return 0; 
#endif
}	 
 
unsigned long CDispatchMessage::GetLengthForKeyInList (char *key, char *list) 
{ 
    CStringToObjectCollection *collection = NULL; 
    CObject *container = NULL; 
 
    if (key == NULL || list == NULL) 
    { 
    	return FALSE; 
    } 
 
    collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
 
    if (collection == NULL) 
    { 
    	// List entry doesn't exist 
    	return FALSE; 
    } 
 
    container = collection->Lookup (key); 
 
    if (container == NULL) 
    { 
    	return 0; 
    } 
 
    // Check if it's a container 
    if (strcmp (container->GetType(),"Container") != 0) 
    { 
    	return 0; 
    } 
 
    // Check it's name 
    if (strcmp (container->GetName(),"StringContainer") == 0) 
    { 
    	size_t stringLength = strlen (((CStringContainer *)container)->GetString()); 
    	return (unsigned long)stringLength; 
    } 
    else if (strcmp (container->GetName(),"ULongContainer") == 0) 
    { 
    	return sizeof (unsigned long); 
    } 
    else if (strcmp (container->GetName(),"ByteContainer") == 0) 
    { 
    	return ((CByteContainer *)container)->GetLength(); 
    } 
    else 
    { 
    	// Not known container 
    	return 0; 
    } 
 
    // Compiler happy
#ifndef __SCO__	
    return 0; 
#endif
}	 
 
void CDispatchMessage::AddValueForKeyInList (char *key, char *value, char *list) 
{ 
    if (key != NULL && value != NULL && list != NULL) 
    { 
    	CStringToObjectCollection *collection; 
    	CStringContainer *container = new CStringContainer; 
 
    	collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
 
    	// Check if list exist 
    	if (collection == NULL) 
    	{ 
    		// Create this new list 
    		collection = new CStringToObjectCollection; 
    		m_Lists->Add (list,collection); 
    	} 
 
    	container->SetString (value); 
    	collection->Add (key,container); 
    } 
} 
 
void CDispatchMessage::AddValueForKeyInList (char *key, unsigned long value, char *list) 
{ 
    if (key != NULL && list != NULL) 
    { 
    	CStringToObjectCollection *collection; 
    	CLongContainer *container = new CLongContainer; 
 
    	collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
 
    	// Check if list exist 
    	if (collection == NULL) 
    	{ 
    		// Create this new list 
    		collection = new CStringToObjectCollection; 
    		m_Lists->Add (list,collection); 
    	} 
 
    	container->SetULong (value); 
    	collection->Add (key,container); 
    } 
} 
 
void CDispatchMessage::AddValueForKeyInList (char *key, BYTE *value, unsigned long valueLength, char *list) 
{ 
    if (key != NULL && value != NULL && list != NULL && valueLength != 0) 
    { 
    	CStringToObjectCollection *collection; 
    	CByteContainer *container = new CByteContainer; 
 
    	collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
 
    	// Check if list exist 
    	if (collection == NULL) 
    	{ 
    		// Create this new list 
    		collection = new CStringToObjectCollection; 
    		m_Lists->Add (list,collection); 
    	} 
 
    	container->SetBytes (value,valueLength); 
    	collection->Add (key,container); 
    } 
} 
 
BOOL CDispatchMessage::GetValueForKeyInList (char *key, char *value, unsigned long valueLength, char *list) 
{ 
    CStringToObjectCollection *collection = NULL; 
    CObject *container = NULL; 
 
    if (key == NULL || value == NULL || valueLength == 0 || list == NULL) 
    { 
    	return FALSE; 
    } 
 
    collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
 
    if (collection == NULL) 
    { 
    	// List entry doesn't exist 
    	return FALSE; 
    } 
 
    container = collection->Lookup (key); 
 
    if (container == NULL) 
    { 
    	return FALSE; 
    } 
 
    // Check for the right name and type 
    if (!(strcmp (container->GetName(),"StringContainer") == 0  &&  
    	strcmp (container->GetType(),"Container") == 0)) 
    { 
    	// Not the right name and type 
    	return FALSE; 
    } 
 
    // Fill the value 
    if (((CStringContainer *)container)->GetString() == NULL) 
    { 
    	value[0] = '\0'; 
    	return TRUE; 
    } 
 
    strncpy (value,((CStringContainer *)container)->GetString(),valueLength); 
 
    return TRUE; 
} 
 
BOOL CDispatchMessage::GetValueForKeyInList (char *key, unsigned long *value, char *list) 
{ 
    CStringToObjectCollection *collection = NULL; 
    CObject *container = NULL; 
 
    if (key == NULL || value == NULL || list == NULL) 
    { 
    	return FALSE; 
    } 
 
    collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
 
    if (collection == NULL) 
    { 
    	// List entry doesn't exist 
    	return FALSE; 
    } 
 
    container = collection->Lookup (key); 
 
    if (container == NULL) 
    { 
    	return FALSE; 
    } 
 
    // Check for the right name and type 
    if (!(strcmp (container->GetName(),"ULongContainer") == 0  &&  
    	strcmp (container->GetType(),"Container") == 0)) 
    { 
    	// Not the right name and type 
    	return FALSE; 
    } 
 
    // Fill the value 
    *value = ((CLongContainer *)container)->GetULong(); 
 
    return TRUE; 
} 
 
BOOL CDispatchMessage::GetValueForKeyInList (char *key, BYTE *value, unsigned long valueLength, char *list) 
{ 
    CStringToObjectCollection *collection = NULL; 
    CObject *container = NULL; 
 
    if (key == NULL || value == NULL || valueLength == 0 || list == NULL) 
    { 
    	return FALSE; 
    } 
 
    collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
 
    if (collection == NULL) 
    { 
    	// List entry doesn't exist 
    	return FALSE; 
    } 
 
    container = collection->Lookup (key); 
 
    if (container == NULL) 
    { 
    	return FALSE; 
    } 
 
    // Check for the right name and type 
    if (!(strcmp (container->GetName(),"ByteContainer") == 0  &&  
    	strcmp (container->GetType(),"Container") == 0)) 
    { 
    	// Not the right name and type 
    	return FALSE; 
    } 
 
    // Fill the value 
    ((CByteContainer *)container)->GetBytes (value,valueLength); 
 
    return TRUE; 
} 
 
BOOL CDispatchMessage::Serialize (void) 
{ 
    CMessage::Serialize (); 
 
    ULONG32 position = 0; 
    ULONG32 positionList = 0; 
    CObject *object = NULL; 
    CObject *objectList = NULL; 
    char key[256]; 
 
	// Serialize message type 
   	AddCharToSerialObject (m_szMessageType,serializedObject); 
 
    // Serialize object count       
    AddULongToSerialObject (m_Values->GetCount(),serializedObject); 
 
    object = m_Values->GetFirst (&position,key,256); 
 
    while (object != NULL) 
    {  
    	// Check if it's a container 
    	if (strcmp (object->GetType(),"Container") == 0) 
    	{ 
    		// Check it's name 
    		if (strcmp (object->GetName(),"StringContainer") == 0) 
    		{ 
    			// Set container flag in serialized object 
    			AddULongToSerialObject (1,serializedObject); 
    			// Serialize string 
    			AddCharToSerialObject (key,serializedObject); 
    			AddCharToSerialObject (((CStringContainer *)object)->GetString(), 
    				serializedObject); 
    		} 
    		else if (strcmp (object->GetName(),"ULongContainer") == 0) 
    		{ 
    			// Set container flag in serialized object 
    			AddULongToSerialObject (2,serializedObject); 
    			// Serialize unsigned long 
    			AddCharToSerialObject (key,serializedObject); 
    			AddULongToSerialObject (((CLongContainer *)object)->GetULong(), 
    				serializedObject); 
    		} 
    		else if (strcmp (object->GetName(),"ByteContainer") == 0) 
    		{ 
    			unsigned long bufferLength = ((CByteContainer *)object)->GetLength(); 
    			BYTE *buffer = new BYTE[bufferLength]; 
    			((CByteContainer *)object)->GetBytes (buffer,bufferLength); 
 
    			// Set container flag in serialized object 
    			AddULongToSerialObject (3,serializedObject); 
    			// Serialize bytes 
    			AddCharToSerialObject (key,serializedObject); 
    			AddBytesToSerialObject (buffer,bufferLength,serializedObject); 
 
    			delete buffer; 
    		} 
    		else 
    		{ 
    			// Set container flag to 0 
    			AddULongToSerialObject (0,serializedObject); 
    		} 
    	} 
    	else 
    	{ 
    		AddULongToSerialObject (0,serializedObject); 
    	} 
 
    	object = m_Values->GetNext (&position,key,256); 
    } 
 
    // Second process Lists 
    positionList = 0; 
    object = NULL; 
    objectList = NULL; 
 
    // Serialize object count   
    AddULongToSerialObject (m_Lists->GetCount(),serializedObject); 
 
    objectList = m_Lists->GetFirst (&positionList,key,256); 
 
    while (objectList != NULL) 
    { 
    	// add list key 
 
    	AddCharToSerialObject (key,serializedObject); 
  
    	AddULongToSerialObject (((CStringToObjectCollection *)objectList)->GetCount(),serializedObject); 
 
    	position = 0; 
    	object = ((CStringToObjectCollection *)objectList)->GetFirst (&position,key,256); 
 
    	while (object != NULL) 
    	{ 
    		// Serialize object 
    		// Check if it's a container 
    		if (strcmp (object->GetType(),"Container") == 0) 
    		{ 
    			// Check it's name 
    			if (strcmp (object->GetName(),"StringContainer") == 0) 
    			{ 
    				// Set container flag in serialized object 
    				AddULongToSerialObject (1,serializedObject); 
    				// Serialize string 
    				AddCharToSerialObject (key,serializedObject); 
    				AddCharToSerialObject (((CStringContainer *)object)->GetString(), 
    					serializedObject); 
    			} 
    			else if (strcmp (object->GetName(),"ULongContainer") == 0) 
    			{ 
    				// Set container flag in serialized object 
    				AddULongToSerialObject (2,serializedObject); 
    				// Serialize unsigned long 
    				AddCharToSerialObject (key,serializedObject); 
    				AddULongToSerialObject (((CLongContainer *)object)->GetULong(), 
    					serializedObject); 
    			} 
    			else if (strcmp (object->GetName(),"ByteContainer") == 0) 
    			{ 
    				unsigned long bufferLength = ((CByteContainer *)object)->GetLength(); 
    				BYTE *buffer = new BYTE[bufferLength]; 
    				((CByteContainer *)object)->GetBytes (buffer,bufferLength); 
 
    				// Set container flag in serialized object 
    				AddULongToSerialObject (3,serializedObject); 
    				// Serialize bytes 
    				AddCharToSerialObject (key,serializedObject); 
    				AddBytesToSerialObject (buffer,bufferLength,serializedObject); 
 
    				delete buffer; 
    			} 
    			else 
    			{ 
    				// Set container flag to 0 
    				AddULongToSerialObject (0,serializedObject); 
    			} 
    		} 
    		else 
    		{ 
    			AddULongToSerialObject (0,serializedObject); 
    		} 
 
    		object = ((CStringToObjectCollection *)objectList)->GetNext (&position,key,256); 
    	} 
 
    	objectList = m_Lists->GetNext (&positionList,key,256); 
    } 
 
    return TRUE; 
} 
 
BOOL CDispatchMessage::UnSerialize (struct SerializedObject* anObject) 
{ 
    CMessage::UnSerialize (anObject); 
 
    CStringToObjectCollection *valueList; 
    char *key; 
    ULONG32 objectCountList; 
    ULONG32 j; 
 
	// Get message type 
    m_szMessageType = GetCharFromSerialObject (serializedObject); 
 
    // Get number of object 
    ULONG32 objectCount = GetULongFromSerialObject (serializedObject); 
    ULONG32 i; 
 
    for (i=0;i<objectCount;i++) 
    { 
    	// Get container ID 
    	unsigned long containerID = GetULongFromSerialObject (serializedObject); 
    	// Get key 
    	key = GetCharFromSerialObject (serializedObject); 
    	if (containerID == 1) 
    	{ 
    		CStringContainer *container = new CStringContainer; 
    		char *stringTemp = GetCharFromSerialObject (serializedObject); 
    		container->SetString (stringTemp); 
    		// Add object to values collection 
    		m_Values->Add (key,container); 
    		delete stringTemp; 
    	} 
    	else if (containerID == 2) 
    	{ 
    		CLongContainer *container = new CLongContainer; 
    		unsigned long ULongTemp = GetULongFromSerialObject (serializedObject); 
    		container->SetULong (ULongTemp); 
    		// Add object to values collection 
    		m_Values->Add (key,container); 
    	} 
    	else if (containerID == 3) 
    	{ 
    		CByteContainer *container = new CByteContainer; 
    		BYTE *byte; 
    		unsigned long byteLength = GetBytesFromSerialObject (&byte,serializedObject); 
    		container->SetBytes (byte,byteLength); 
    		// Add object to values collection 
    		m_Values->Add (key,container); 
    		delete byte; 
    	} 
 
    	// Delete key 
    	delete key; 
    } 
 
    objectCountList = GetULongFromSerialObject (serializedObject); 
 
    for (j=0;j<objectCountList;j++) 
    { 
    	// Get key 
    	key = GetCharFromSerialObject (serializedObject); 
 
    	// Create value list 
    	valueList = new CStringToObjectCollection; 
    	m_Lists->Add (key,valueList); 
 
    	// Delete key 
    	delete key; 
 
    	// Get number of object 
    	objectCount = GetULongFromSerialObject (serializedObject); 
 
    	for (i=0;i<objectCount;i++) 
    	{ 
    		// Get container ID 
    		unsigned long containerID = GetULongFromSerialObject (serializedObject); 
    		// Get key 
    		key = GetCharFromSerialObject (serializedObject); 
    		if (containerID == 1) 
    		{ 
    			CStringContainer *container = new CStringContainer; 
    			char *stringTemp = GetCharFromSerialObject (serializedObject); 
    			container->SetString (stringTemp); 
    			// Add object to values collection 
    			valueList->Add (key,container); 
    			delete stringTemp; 
    		} 
    		else if (containerID == 2) 
    		{ 
    			CLongContainer *container = new CLongContainer; 
    			unsigned long ULongTemp = GetULongFromSerialObject (serializedObject); 
    			container->SetULong (ULongTemp); 
    			// Add object to values collection 
    			valueList->Add (key,container); 
    		} 
    		else if (containerID == 3) 
    		{ 
    			CByteContainer *container = new CByteContainer; 
    			BYTE *byte; 
    			unsigned long byteLength = GetBytesFromSerialObject (&byte,serializedObject); 
    			container->SetBytes (byte,byteLength); 
    			// Add object to values collection 
    			valueList->Add (key,container); 
    			delete byte; 
    		} 
 
    		// Delete key 
    		delete key; 
    	} 
    } 
 
    return TRUE; 
} 
 
CObject *CDispatchMessage::Clone (void) 
{ 
    CDispatchMessage *tempObject = new CDispatchMessage; 
    return (CObject *) tempObject; 
} 
