    // GenericMessage.cpp: implementation of the CGenericMessage class. 
    // 
    ////////////////////////////////////////////////////////////////////// 
     
    #include "../../Include/Comm/GenericMessage.h" 
    #include "../../Include/Base/StringToObjectCollection.h" 
    #include "../../Include/Base/StringContainer.h" 
    #include "../../Include/Base/ULongContainer.h" 
    #include "../../Include/Base/ByteContainer.h" 
 
#ifdef linux 
  #include <stddef.h> 
  #include <string.h> 
  #include <stdio.h> 
#endif //linux 
     
#ifdef __SCO__ 
  #include <stddef.h> 
  #include <string.h> 
  #include <stdio.h> 
#endif // __SCO__ 
     
#ifdef __HPUX__ 
  #include <stddef.h> 
  #include <string.h> 
  #include <stdio.h> 
#endif // __HPUX__ 
      
    ////////////////////////////////////////////////////////////////////// 
    // Construction/Destruction 
    ////////////////////////////////////////////////////////////////////// 
     
    CGenericMessage::CGenericMessage() : CMessage ("GenericMessage") 
    { 
    	m_Values = new CStringToObjectCollection; 
    	m_Lists = new CStringToObjectCollection; 
    } 
     
    CGenericMessage::CGenericMessage(char *messageName) : CMessage (messageName) 
    { 
    	m_Values = new CStringToObjectCollection; 
    	m_Lists = new CStringToObjectCollection; 
    } 
     
    CGenericMessage::~CGenericMessage() 
    { 
    	ULONG32 position = 0; 
    	ULONG32 positionList = 0; 
    	CObject *object = NULL; 
    	char key[256]; 
    	CObject *objectList = NULL; 
    	char keyList[256]; 
     
    	// Delete all collection in Lists 
    	object = m_Lists->GetFirst (&position,key,256); 
     
    	while (object != NULL) 
    	{ 
    		objectList = ((CStringToObjectCollection *)object)->GetFirst (&positionList,keyList,256); 
    		while (objectList != NULL) 
    		{ 
    			delete objectList; 
    			objectList = ((CStringToObjectCollection *)object)->GetNext (&positionList,keyList,256); 
    		} 
    		delete object; 
    		object = m_Lists->GetNext (&position,key,256); 
    	} 
     
    	delete m_Lists; 
     
    	// Delete all containers in Values 
    	object = m_Values->GetFirst (&position,key,256); 
     
    	while (object != NULL) 
    	{ 
    		delete object; 
    		object = m_Values->GetNext (&position,key,256); 
    	} 
        
    	delete m_Values; 
    } 
     
    void CGenericMessage::AddValueForKey (char *key, char *value) 
    { 
    	CStringContainer *container; 
     
    	if (key != NULL && value != NULL) 
    	{ 
    		container = new CStringContainer;
     
    		container->SetString (value);
    		m_Values->Add (key,container);
    	} 
    } 
     
    void CGenericMessage::AddValueForKey (char *key, unsigned long value) 
    { 
    	CLongContainer *container; 
     
    	if (key != NULL) 
    	{ 
    		container = new CLongContainer; 
     
    		container->SetULong (value); 
    		m_Values->Add (key,container); 
    	} 
    } 
     
    void CGenericMessage::AddValueForKey (char *key, BYTE *value, unsigned long valueLength) 
    { 
    	CByteContainer *container; 
     
    	if (key != NULL && value != NULL && valueLength != 0) 
    	{ 
    		container = new CByteContainer; 
     
    		container->SetBytes (value,valueLength); 
    		m_Values->Add (key,container); 
    	} 
    } 
     
    BOOL CGenericMessage::GetValueForKey (char *key, char *value, unsigned long valueLength) 
    { 
    	CObject *container = NULL; 
     
    	if (key == NULL || value == NULL || valueLength == 0) 
    	{ 
    		return FALSE; 
    	} 
     
    	container = m_Values->Lookup (key); 
     
    	if (container == NULL) 
    	{ 
    		return FALSE; 
    	} 
     
    	// Check for the right name and type 
    	if (!(strcmp (container->GetName(),"StringContainer") == 0  &&  
    		strcmp (container->GetType(),"Container") == 0)) 
    	{ 
    		// Not the right name and type 
    		return FALSE; 
    	} 
     
    	// Fill the value 
    	if (((CStringContainer *)container)->GetString() == NULL) 
    	{ 
    		value[0] = '\0'; 
    	} 
    	else 
    	{ 
    		strncpy (value,((CStringContainer *)container)->GetString(),valueLength); 
    	} 
     
    	return TRUE; 
    } 
     
    BOOL CGenericMessage::GetValueForKey (char *key, unsigned long *value) 
    { 
    	CObject *container = NULL; 
     
    	if (key == NULL || value == NULL) 
    	{ 
    		return FALSE; 
    	} 
     
    	container = m_Values->Lookup (key); 
     
    	if (container == NULL) 
    	{ 
    		return FALSE; 
    	} 
     
    	// Check for the right name and type 
    	if (!(strcmp (container->GetName(),"ULongContainer") == 0 && 
    		strcmp (container->GetType(),"Container") == 0)) 
    	{ 
    		// Not the right name and type 
    		return FALSE; 
    	} 
     
    	// Fill the value 
    	*value = ((CLongContainer *)container)->GetULong(); 
     
    	return TRUE; 
    } 
     
    BOOL CGenericMessage::GetValueForKey (char *key, BYTE *value, unsigned long valueLength) 
    { 
    	CObject *container = NULL; 
     
    	if (key == NULL || value == NULL || valueLength == 0) 
    	{ 
    		return FALSE; 
    	} 
     
    	container = m_Values->Lookup (key); 
     
    	if (container == NULL) 
    	{ 
    		return FALSE; 
    	} 
     
    	// Check for the right name and type 
    	if (!(strcmp (container->GetName(),"ByteContainer") == 0  &&  
    		strcmp (container->GetType(),"Container") == 0)) 
    	{ 
    		// Not the right name and type 
    		return FALSE; 
    	} 
     
    	// Fill the value 
    	if (((CByteContainer *)container)->GetBytes(value,valueLength) == FALSE) 
    	{ 
    		// value size to short 
    		return FALSE; 
    	} 
     
    	return TRUE; 
    } 
     
    unsigned long CGenericMessage::GetLengthForKey (char *key) 
    { 
    	CObject *container = NULL; 
     
    	if (key == NULL) 
    	{ 
    		return 0; 
    	} 
     
    	container = m_Values->Lookup (key); 
     
    	if (container == NULL) 
    	{ 
    		return 0; 
    	} 
     
    	// Check if it's a container 
    	if (strcmp (container->GetType(),"Container") != 0) 
    	{ 
    		return 0; 
    	} 
     
    	// Check it's name 
    	if (strcmp (container->GetName(),"StringContainer") == 0) 
    	{ 
  		if (((CStringContainer *)container)->GetString() == NULL) 
  		{ 
  			return 0; 
  		} 
  		else 
  		{ 
 	   		size_t stringLength = strlen (((CStringContainer *)container)->GetString()); 
    			return (unsigned long)stringLength; 
 	   	} 
  	} 
    	else if (strcmp (container->GetName(),"ULongContainer") == 0) 
    	{ 
    		return sizeof (unsigned long); 
    	} 
    	else if (strcmp (container->GetName(),"ByteContainer") == 0) 
    	{ 
//  		//printf ("Get Length for key : %s length : %ld\n",key,((CByteContainer *)container)->GetLength()); 
    		return ((CByteContainer *)container)->GetLength(); 
    	} 
    	else 
    	{ 
    		// Not known container 
    		return 0; 
    	} 
     
    	// Compiler happy 
#ifndef __SCO__
    	return 0; 
#endif
    }	 
     
    unsigned long CGenericMessage::GetLengthForKeyInList (char *key, char *list) 
    { 
    	CStringToObjectCollection *collection = NULL; 
    	CObject *container = NULL; 
     
    	if (key == NULL || list == NULL) 
    	{ 
    		return FALSE; 
    	} 
     
    	collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
     
    	if (collection == NULL) 
    	{ 
    		// List entry doesn't exist 
    		return FALSE; 
    	} 
     
    	container = collection->Lookup (key); 
     
    	if (container == NULL) 
    	{ 
    		return 0; 
    	} 
     
    	// Check if it's a container 
    	if (strcmp (container->GetType(),"Container") != 0) 
    	{ 
    		return 0; 
    	} 
     
    	// Check it's name 
    	if (strcmp (container->GetName(),"StringContainer") == 0) 
    	{ 
    		size_t stringLength = strlen (((CStringContainer *)container)->GetString()); 
    		return (unsigned long)stringLength; 
    	} 
    	else if (strcmp (container->GetName(),"ULongContainer") == 0) 
    	{ 
    		return sizeof (unsigned long); 
    	} 
    	else if (strcmp (container->GetName(),"ByteContainer") == 0) 
    	{ 
    		return ((CByteContainer *)container)->GetLength(); 
    	} 
    	else 
    	{ 
    		// Not known container 
    		return 0; 
    	} 
     
    	// Compiler happy 
#ifndef __SCO__
    	return 0; 
#endif
    }	 
     
    void CGenericMessage::AddValueForKeyInList (char *key, char *value, char *list) 
    { 
    	if (key != NULL && value != NULL && list != NULL) 
    	{ 
    		CStringToObjectCollection *collection; 
    		CStringContainer *container = new CStringContainer; 
     
    		collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
     
    		// Check if list exist 
    		if (collection == NULL) 
    		{ 
    			// Create this new list 
    			collection = new CStringToObjectCollection; 
    			m_Lists->Add (list,collection); 
    		} 
     
    		container->SetString (value); 
    		collection->Add (key,container); 
    	} 
    } 
     
    void CGenericMessage::AddValueForKeyInList (char *key, unsigned long value, char *list) 
    { 
    	if (key != NULL && list != NULL) 
    	{ 
    		CStringToObjectCollection *collection; 
    		CLongContainer *container = new CLongContainer; 
     
    		collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
     
    		// Check if list exist 
    		if (collection == NULL) 
    		{ 
    			// Create this new list 
    			collection = new CStringToObjectCollection; 
    			m_Lists->Add (list,collection); 
    		} 
     
    		container->SetULong (value); 
    		collection->Add (key,container); 
    	} 
    } 
     
    void CGenericMessage::AddValueForKeyInList (char *key, BYTE *value, unsigned long valueLength, char *list) 
    { 
    	if (key != NULL && value != NULL && list != NULL && valueLength != 0) 
    	{ 
    		CStringToObjectCollection *collection; 
    		CByteContainer *container = new CByteContainer; 
     
    		collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
     
    		// Check if list exist 
    		if (collection == NULL) 
    		{ 
    			// Create this new list 
    			collection = new CStringToObjectCollection; 
    			m_Lists->Add (list,collection); 
    		} 
     
    		container->SetBytes (value,valueLength); 
    		collection->Add (key,container); 
    	} 
    } 
     
    BOOL CGenericMessage::GetValueForKeyInList (char *key, char *value, unsigned long valueLength, char *list) 
    { 
    	CStringToObjectCollection *collection = NULL; 
    	CObject *container = NULL; 
     
    	if (key == NULL || value == NULL || valueLength == 0 || list == NULL) 
    	{ 
    		return FALSE; 
    	} 
     
    	collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
     
    	if (collection == NULL) 
    	{ 
    		// List entry doesn't exist 
    		return FALSE; 
    	} 
     
    	container = collection->Lookup (key); 
     
    	if (container == NULL) 
    	{ 
    		return FALSE; 
    	} 
     
    	// Check for the right name and type 
    	if (!(strcmp (container->GetName(),"StringContainer") == 0  &&  
    		strcmp (container->GetType(),"Container") == 0)) 
    	{ 
    		// Not the right name and type 
    		return FALSE; 
    	} 
     
    	// Fill the value 
    	if (((CStringContainer *)container)->GetString() == NULL) 
    	{ 
    		value[0] = '\0'; 
    		return TRUE; 
    	} 
     
    	strncpy (value,((CStringContainer *)container)->GetString(),valueLength); 
     
    	return TRUE; 
    } 
     
    BOOL CGenericMessage::GetValueForKeyInList (char *key, unsigned long *value, char *list) 
    { 
    	CStringToObjectCollection *collection = NULL; 
    	CObject *container = NULL; 
     
    	if (key == NULL || value == NULL || list == NULL) 
    	{ 
    		return FALSE; 
    	} 
     
    	collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
     
    	if (collection == NULL) 
    	{ 
    		// List entry doesn't exist 
    		return FALSE; 
    	} 
     
    	container = collection->Lookup (key); 
     
    	if (container == NULL) 
    	{ 
    		return FALSE; 
    	} 
     
    	// Check for the right name and type 
    	if (!(strcmp (container->GetName(),"ULongContainer") == 0  &&  
    		strcmp (container->GetType(),"Container") == 0)) 
    	{ 
    		// Not the right name and type 
    		return FALSE; 
    	} 
     
    	// Fill the value 
    	*value = ((CLongContainer *)container)->GetULong(); 
     
    	return TRUE; 
    } 
     
    BOOL CGenericMessage::GetValueForKeyInList (char *key, BYTE *value, unsigned long valueLength, char *list) 
    { 
    	CStringToObjectCollection *collection = NULL; 
    	CObject *container = NULL; 
     
    	if (key == NULL || value == NULL || valueLength == 0 || list == NULL) 
    	{ 
    		return FALSE; 
    	} 
     
    	collection = (CStringToObjectCollection *)m_Lists->Lookup (list); 
     
    	if (collection == NULL) 
    	{ 
    		// List entry doesn't exist 
    		return FALSE; 
    	} 
     
    	container = collection->Lookup (key); 
     
    	if (container == NULL) 
    	{ 
    		return FALSE; 
    	} 
     
    	// Check for the right name and type 
    	if (!(strcmp (container->GetName(),"ByteContainer") == 0  &&  
    		strcmp (container->GetType(),"Container") == 0)) 
    	{ 
    		// Not the right name and type 
    		return FALSE; 
    	} 
     
    	// Fill the value 
    	((CByteContainer *)container)->GetBytes (value,valueLength); 
     
    	return TRUE; 
    } 
     
	CStringToObjectCollection *CGenericMessage::GetValues (void)
	{
		return m_Values;
	}

	CStringToObjectCollection *CGenericMessage::GetValuesInList (char *list)
	{
		if (list == NULL) 
    	{ 
    		return NULL; 
    	} 
     
    	return (CStringToObjectCollection *)m_Lists->Lookup (list); 
	}

    BOOL CGenericMessage::Serialize (void) 
    { 
    	CMessage::Serialize (); 
     
    	ULONG32 position = 0; 
    	ULONG32 positionList = 0; 
    	CObject *object = NULL; 
    	CObject *objectList = NULL; 
    	char key[256]; 
     
    	// First process Values 
     
    	// Serialize object count  
  	//printf ("Serialize Generic Message\n"); 
  	 
  	//printf ("Values\n"); 
    	 
    	AddULongToSerialObject (m_Values->GetCount(),serializedObject); 
     
    	object = m_Values->GetFirst (&position,key,256); 
     
    	while (object != NULL) 
    	{ 
    		// Serialize object 
  		//printf ("Key : %s\n",key); 
  		//printf ("Type : %s\n",object->GetType()); 
  		//printf ("Name : %s\n",object->GetName()); 
     
    		// Check if it's a container 
    		if (strcmp (object->GetType(),"Container") == 0) 
    		{ 
    			// Check it's name 
    			if (strcmp (object->GetName(),"StringContainer") == 0) 
    			{ 
    				// Set container flag in serialized object 
    				AddULongToSerialObject (1,serializedObject); 
    				// Serialize string 
    				AddCharToSerialObject (key,serializedObject); 
    				AddCharToSerialObject (((CStringContainer *)object)->GetString(), 
    					serializedObject); 
    			} 
    			else if (strcmp (object->GetName(),"ULongContainer") == 0) 
    			{ 
    				// Set container flag in serialized object 
    				AddULongToSerialObject (2,serializedObject); 
    				// Serialize unsigned long 
    				AddCharToSerialObject (key,serializedObject); 
    				AddULongToSerialObject (((CLongContainer *)object)->GetULong(), 
    					serializedObject); 
    			} 
    			else if (strcmp (object->GetName(),"ByteContainer") == 0) 
    			{ 
    				unsigned long bufferLength = ((CByteContainer *)object)->GetLength(); 
    				BYTE *buffer = new BYTE[bufferLength]; 
    				((CByteContainer *)object)->GetBytes (buffer,bufferLength); 
     
    				// Set container flag in serialized object 
    				AddULongToSerialObject (3,serializedObject); 
    				// Serialize bytes 
    				AddCharToSerialObject (key,serializedObject); 
    				AddBytesToSerialObject (buffer,bufferLength,serializedObject); 
     
    				delete buffer; 
    			} 
    			else 
    			{ 
    				// Set container flag to 0 
    				AddULongToSerialObject (0,serializedObject); 
    			} 
    		} 
    		else 
    		{ 
    			AddULongToSerialObject (0,serializedObject); 
    		} 
     
    		object = m_Values->GetNext (&position,key,256); 
    	} 
     
    	// Second process Lists 
    	positionList = 0; 
    	object = NULL; 
    	objectList = NULL; 
     
    	// Serialize object count  
    	 
  	//printf ("Lists \n"); 
  	 
    	AddULongToSerialObject (m_Lists->GetCount(),serializedObject); 
     
    	objectList = m_Lists->GetFirst (&positionList,key,256); 
     
    	while (objectList != NULL) 
    	{ 
    		// add list key 
     
    		AddCharToSerialObject (key,serializedObject); 
     
  		//printf ("List key : %s\n",key); 
   
    		AddULongToSerialObject (((CStringToObjectCollection *)objectList)->GetCount(),serializedObject); 
     
    		position = 0; 
    		object = ((CStringToObjectCollection *)objectList)->GetFirst (&position,key,256); 
     
    		while (object != NULL) 
    		{ 
    			// Serialize object 
  			//printf ("Key : %s\n",key); 
  			//printf ("Type : %s\n",object->GetType()); 
  			//printf ("Name : %s\n",object->GetName()); 
     
    			// Check if it's a container 
    			if (strcmp (object->GetType(),"Container") == 0) 
    			{ 
    				// Check it's name 
    				if (strcmp (object->GetName(),"StringContainer") == 0) 
    				{ 
    					// Set container flag in serialized object 
    					AddULongToSerialObject (1,serializedObject); 
    					// Serialize string 
    					AddCharToSerialObject (key,serializedObject); 
    					AddCharToSerialObject (((CStringContainer *)object)->GetString(), 
    						serializedObject); 
    				} 
    				else if (strcmp (object->GetName(),"ULongContainer") == 0) 
    				{ 
    					// Set container flag in serialized object 
    					AddULongToSerialObject (2,serializedObject); 
    					// Serialize unsigned long 
    					AddCharToSerialObject (key,serializedObject); 
    					AddULongToSerialObject (((CLongContainer *)object)->GetULong(), 
    						serializedObject); 
    				} 
    				else if (strcmp (object->GetName(),"ByteContainer") == 0) 
    				{ 
    					unsigned long bufferLength = ((CByteContainer *)object)->GetLength(); 
    					BYTE *buffer = new BYTE[bufferLength]; 
    					((CByteContainer *)object)->GetBytes (buffer,bufferLength); 
     
    					// Set container flag in serialized object 
    					AddULongToSerialObject (3,serializedObject); 
    					// Serialize bytes 
    					AddCharToSerialObject (key,serializedObject); 
    					AddBytesToSerialObject (buffer,bufferLength,serializedObject); 
     
    					delete buffer; 
    				} 
    				else 
    				{ 
    					// Set container flag to 0 
    					AddULongToSerialObject (0,serializedObject); 
    				} 
    			} 
    			else 
    			{ 
    				AddULongToSerialObject (0,serializedObject); 
    			} 
     
    			object = ((CStringToObjectCollection *)objectList)->GetNext (&position,key,256); 
    		} 
     
    		objectList = m_Lists->GetNext (&positionList,key,256); 
    	} 
     
    	return TRUE; 
    } 
     
    BOOL CGenericMessage::UnSerialize (struct SerializedObject* anObject) 
    { 
    	CMessage::UnSerialize (anObject); 
     
    	CStringToObjectCollection *valueList; 
    	char *key; 
    	ULONG32 objectCountList; 
    	ULONG32 j; 
     
    	// Get number of object 
    	ULONG32 objectCount = GetULongFromSerialObject (serializedObject); 
    	ULONG32 i; 
     
    	for (i=0;i<objectCount;i++) 
    	{ 
    		// Get container ID 
    		unsigned long containerID = GetULongFromSerialObject (serializedObject); 
    		// Get key 
    		key = GetCharFromSerialObject (serializedObject); 
  		//printf ("Key = %s\n",key); 
    		if (containerID == 1) 
    		{ 
    			CStringContainer *container = new CStringContainer; 
    			char *stringTemp = GetCharFromSerialObject (serializedObject); 
    			container->SetString (stringTemp); 
    			// Add object to values collection 
    			m_Values->Add (key,container); 
    			delete stringTemp; 
    		} 
    		else if (containerID == 2) 
    		{ 
    			CLongContainer *container = new CLongContainer; 
    			unsigned long ULongTemp = GetULongFromSerialObject (serializedObject); 
    			container->SetULong (ULongTemp); 
    			// Add object to values collection 
    			m_Values->Add (key,container); 
    		} 
    		else if (containerID == 3) 
    		{ 
    			CByteContainer *container = new CByteContainer; 
    			BYTE *byte; 
    			unsigned long byteLength = GetBytesFromSerialObject (&byte,serializedObject); 
    			container->SetBytes (byte,byteLength); 
    			// Add object to values collection 
    			m_Values->Add (key,container); 
    			delete byte; 
    		} 
     
    		// Delete key 
    		delete key; 
    	} 
     
    	objectCountList = GetULongFromSerialObject (serializedObject); 
     
    	for (j=0;j<objectCountList;j++) 
    	{ 
    		// Get key 
    		key = GetCharFromSerialObject (serializedObject); 
     
    		// Create value list 
    		valueList = new CStringToObjectCollection; 
    		m_Lists->Add (key,valueList); 
     
    		// Delete key 
    		delete key; 
     
    		// Get number of object 
    		objectCount = GetULongFromSerialObject (serializedObject); 
     
    		for (i=0;i<objectCount;i++) 
    		{ 
    			// Get container ID 
    			unsigned long containerID = GetULongFromSerialObject (serializedObject); 
    			// Get key 
    			key = GetCharFromSerialObject (serializedObject); 
    			if (containerID == 1) 
    			{ 
    				CStringContainer *container = new CStringContainer; 
    				char *stringTemp = GetCharFromSerialObject (serializedObject); 
    				container->SetString (stringTemp); 
    				// Add object to values collection 
    				valueList->Add (key,container); 
    				delete stringTemp; 
    			} 
    			else if (containerID == 2) 
    			{ 
    				CLongContainer *container = new CLongContainer; 
    				unsigned long ULongTemp = GetULongFromSerialObject (serializedObject); 
    				container->SetULong (ULongTemp); 
    				// Add object to values collection 
    				valueList->Add (key,container); 
    			} 
    			else if (containerID == 3) 
    			{ 
    				CByteContainer *container = new CByteContainer; 
    				BYTE *byte; 
    				unsigned long byteLength = GetBytesFromSerialObject (&byte,serializedObject); 
    				container->SetBytes (byte,byteLength); 
    				// Add object to values collection 
    				valueList->Add (key,container); 
    				delete byte; 
    			} 
     
    			// Delete key 
    			delete key; 
    		} 
    	} 
     
    	return TRUE; 
    } 
     
    CObject *CGenericMessage::Clone (void) 
    { 
    	CGenericMessage *tempObject = new CGenericMessage; 
    	return (CObject *) tempObject; 
    } 

	CObject *CGenericMessage::Copy (void)
	{
    	ULONG32 position = 0; 
    	ULONG32 positionList = 0; 
    	CObject *object = NULL; 
    	CObject *objectList = NULL; 
    	char key[256]; 
    	char keyList[256]; 

		CGenericMessage *messageCopy = new CGenericMessage;

		// First the values

    	object = m_Values->GetFirst (&position,key,256); 
     
    	while (object != NULL) 
    	{      
    		// Check if it's a container 
    		if (strcmp (object->GetType(),"Container") == 0) 
    		{ 
    			// Check it's name 
    			if (strcmp (object->GetName(),"StringContainer") == 0) 
    			{
					// Add string
					messageCopy->AddValueForKey (key,((CStringContainer *)object)->GetString());
    			} 
    			else if (strcmp (object->GetName(),"ULongContainer") == 0) 
    			{ 
					// Add ULong
					messageCopy->AddValueForKey (key,((CLongContainer *)object)->GetULong());
    			} 
    			else if (strcmp (object->GetName(),"ByteContainer") == 0) 
    			{ 
					// Add Byte
    				unsigned long bufferLength = ((CByteContainer *)object)->GetLength(); 
    				BYTE *buffer = new BYTE[bufferLength]; 
    				((CByteContainer *)object)->GetBytes (buffer,bufferLength); 

					messageCopy->AddValueForKey (key,buffer,bufferLength);

    				delete buffer; 
    			} 
    		} 
     
    		object = m_Values->GetNext (&position,key,256); 
    	} 

		// Then lists

    	objectList = m_Lists->GetFirst (&positionList,keyList,256); 
     
    	while (objectList != NULL) 
    	{      
    		position = 0; 

    		object = ((CStringToObjectCollection *)objectList)->GetFirst (&position,key,256); 
     
    		while (object != NULL) 
    		{ 
    			// Check if it's a container 
    			if (strcmp (object->GetType(),"Container") == 0) 
    			{ 
    				// Check it's name 
    				if (strcmp (object->GetName(),"StringContainer") == 0) 
    				{
						// Add string
						messageCopy->AddValueForKeyInList (key,((CStringContainer *)object)->GetString(),keyList);
    				} 
    				else if (strcmp (object->GetName(),"ULongContainer") == 0) 
    				{ 
						// Add ULong
						messageCopy->AddValueForKeyInList (key,((CLongContainer *)object)->GetULong(),keyList);
    				} 
    				else if (strcmp (object->GetName(),"ByteContainer") == 0) 
    				{ 
						// Add Byte
    					unsigned long bufferLength = ((CByteContainer *)object)->GetLength(); 
    					BYTE *buffer = new BYTE[bufferLength]; 
    					((CByteContainer *)object)->GetBytes (buffer,bufferLength); 

						messageCopy->AddValueForKeyInList (key,buffer,bufferLength,keyList);

    					delete buffer; 
    				} 
    			} 
     
    			object = ((CStringToObjectCollection *)objectList)->GetNext (&position,key,256); 
    		} 
     
    		objectList = m_Lists->GetNext (&positionList,keyList,256); 
    	} 

		return messageCopy;

	}
