// ServerSessionDispatcher.cpp: implementation of the CServerSessionDispatcher class. 
// 
////////////////////////////////////////////////////////////////////// 
 
#include "../../Include/Comm/ServerSessionDispatcher.h" 
 
#include <stdio.h> 
 
#include "../../Include/Base/LongToObjectCollection.h" 
#include "../../Include/Base/MasterManager.h" 
#include "../../Include/Comm/Message.h" 
#include "../../Include/Comm/GenericMessage.h" 
#include "../../Include/Comm/DispatchMessage.h" 
#include "../../Include/Comm/MessageStack.h" 
#include "../../Include/Comm/Connection.h" 
#include "../../Include/Comm/MessageDispatcherManager.h" 
 
#ifdef linux 
#include <stddef.h> 
#include <string.h> 
#endif //linux 
     
#ifdef __SCO__ 
#include <stddef.h> 
#include <string.h> 
#endif // __SCO__ 
     
 
////////////////////////////////////////////////////////////////////// 
// Construction/Destruction 
////////////////////////////////////////////////////////////////////// 
 
CServerSessionDispatcher::CServerSessionDispatcher() : CServerSession ("ServerSessionDispatcher") 
{ 
 
} 
 
CServerSessionDispatcher::~CServerSessionDispatcher() 
{ 
 
} 
 
void CServerSessionDispatcher::Tick (void) 
{ 
	CMasterManager *manager = CMasterManager::Instance(); 
 
	if (manager == NULL) 
	{ 
		return; 
	} 
 
    if (m_ReceiveStack == NULL || m_SendStack == NULL) 
    { 
		return; 
	} 
 
    // Check for new message 
 
    while (m_ReceiveStack->IsMessageAvailable() == TRUE) 
    { 
		CMessage *message = m_ReceiveStack->GetMessage(); 
 
		if (message == NULL) 
		{ 
			return; 
		} 
 
		char *messageName = message->GetName(); 
		char *messageType = message->GetType(); 
 
		if (messageName == NULL || messageType == NULL) 
		{ 
			return; 
		} 
 
		if (!(strcmp(messageName,"DispatchMessage") == 0 && strcmp (messageType,"Message") == 0)) 
		{ 
			if (!(strcmp(messageName,"GenericMessage") == 0 && strcmp (messageType,"Message") == 0)) 
			{ 
				// Send it back to sender 
				m_Connection->SendMessage (message); 
 
				return; 
			} 
			else 
			{ 
				CGenericMessage *genMessage = (CGenericMessage *)message; 
 
				// The message is not handled, set the '#DispatchKey#Error#' value to Yes 
				// and set the '#DispatchKey#Error#***ErrorCode***' to 2 
				// and set the '#DispatchKey#Error#***ErrorText***' to "Not a DispatchMessage" 
				genMessage->AddValueForKey ("#DispatchKey#Error#","Yes"); 
				genMessage->AddValueForKey ("#DispatchKey#Error#***ErrorCode***",2); 
				genMessage->AddValueForKey ("#DispatchKey#Error#***ErrorText***","Not a DispatchMessage"); 
 
				// Send it back to sender 
				m_Connection->SendMessage (message); 
 
				return; 
			} 
		} 
 
		CDispatchMessage *poMessage = (CDispatchMessage *)message; 
 
		CMessageDispatcherManager *dispatcher = (CMessageDispatcherManager *) manager->GetManager ("MessageDispatcher"); 
 
		if (dispatcher == NULL) 
		{ 
			return; 
		} 
 
		// Message dispatcher found, now check if this new message can be handled by of the CDispatchMessageHandler 
		if (dispatcher->IsMessageHandled (poMessage) == FALSE) 
		{ 
			// The message is not handled, set the '#DispatchKey#Error#' value to Yes 
			// and set the '#DispatchKey#Error#***ErrorCode***' to 1 
			// and set the '#DispatchKey#Error#***ErrorText***' to "Can't find handler" 
			poMessage->AddValueForKey ("#DispatchKey#Error#","Yes"); 
			poMessage->AddValueForKey ("#DispatchKey#Error#***ErrorCode***",1); 
			poMessage->AddValueForKey ("#DispatchKey#Error#***ErrorText***","Can't find handler"); 
 
			// And send the message back to it's sender 
			m_Connection->SendMessage (poMessage); 
 
			return; 
		} 
 
		// Send the message to the dispatcher 
		dispatcher->AddMessage (poMessage); 
	} 
} 
 
CObject *CServerSessionDispatcher::Clone (void) 
{ 
	CServerSessionDispatcher *tempObject = new CServerSessionDispatcher; 
	return (CObject *) tempObject; 
} 
