// ApplicationObject.cpp: implementation of the CApplicationObject class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "ApplicationObject.h"
#include <stdlib.h>
#include <time.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CApplicationObject::CApplicationObject()
{
    m_hContext = 0;
    m_lConnID = 0;
    m_lRefCount = 0;
}

CApplicationObject::~CApplicationObject()
{
    CAppReaderObject *pObject = NULL;
    ULONG32 position = 0;
	pObject = (CAppReaderObject *)m_oReaders.GetFirst (&position); 

	while (pObject != NULL) 
	{
        delete pObject;
		pObject = (CAppReaderObject *) m_oReaders.GetNext (&position); 
	}
    m_oReaders.RemoveAll();
}

void CApplicationObject::SetConnID(long lConnID)
{
    m_lConnID = lConnID;
}

long CApplicationObject::GetConnID()
{
    return m_lConnID;
}

void CApplicationObject::SetPID(long lPID)
{
    m_lPID = lPID;
}

long CApplicationObject::GetPID()
{
    return m_lPID;
}

void CApplicationObject::SetContext(SCARDCONTEXT hContext)
{
    m_hContext = hContext;
}

SCARDCONTEXT CApplicationObject::GetContext()
{
    return m_hContext;
}

void CApplicationObject::SetApplicationName(char *pszApplicationName)
{
    m_strApplicationName.SetString(pszApplicationName);
}

char *CApplicationObject::GetApplicationName()
{
    return m_strApplicationName.GetString();
}

void CApplicationObject::SetUserName(char *pszUserName)
{
    m_strUserName.SetString(pszUserName);
}

char *CApplicationObject::GetUserName()
{
    return m_strUserName.GetString();
}

SCARDHANDLE CApplicationObject::AddReader(CReaderObject *pReader)
{
    SCARDHANDLE hCard = 0;
    if(pReader != NULL)
    {
        // Lookup
        CAppReaderObject *pObject = NULL;
        ULONG32 position = 0;
        long lKey = 0;
	    pObject = (CAppReaderObject *)m_oReaders.GetFirst (&position, &lKey); 

	    while (pObject != NULL) 
	    { 
		    if (pObject->pReader->GetCardHandle() == pReader->GetCardHandle() ) 
		    { 
                pReader->AddRef(); 
			    // And exit 
			    return lKey; 
		    } 
		    pObject = (CAppReaderObject *) m_oReaders.GetNext (&position, &lKey); 
	    } 

        // Not found, create random CardHandle
        time_t ltime = time( NULL );
        srand( ltime );
        hCard = rand();
        pReader->AddRef();
        CAppReaderObject *pAppReaderObject = new CAppReaderObject();
        pAppReaderObject->pReader = pReader;
        pAppReaderObject->hOriginal = pReader->GetCardHandle(); 
        m_oReaders.Add(hCard, pAppReaderObject);
    }
    return hCard;
}

void CApplicationObject::DeleteReader(SCARDHANDLE hHandle)
{
    // Lookup
    CReaderObject *pObject = NULL;
    CAppReaderObject *pAppReader = NULL;
    pAppReader = (CAppReaderObject *)m_oReaders.Lookup(hHandle);
    if(pAppReader != NULL)
    {
        pObject = pAppReader->pReader;
    }
    if (pObject != NULL) 
    {
        long lRef = pObject->ReleaseRef();
        if (0 == lRef)
        {
            delete pAppReader;
            m_oReaders.Remove(hHandle);
        }        
    } 
}

CReaderObject *CApplicationObject::GetReader(SCARDHANDLE hHandle)
{
    CReaderObject *pReader = NULL;
    CAppReaderObject *pAppReader = NULL;
    pAppReader = (CAppReaderObject *)m_oReaders.Lookup(hHandle);
    if(pAppReader != NULL)
    {
        pReader = pAppReader->pReader;
    }
    return pReader;
}

BOOL CApplicationObject::MatchOriginal(SCARDHANDLE hHandle)
{
    BOOL bRet = FALSE;
    CReaderObject *pReader = NULL;
    CAppReaderObject *pAppReader = NULL;
    pAppReader = (CAppReaderObject *)m_oReaders.Lookup(hHandle);
    if(pAppReader != NULL)
    {
        pReader = pAppReader->pReader;
        if(pReader != NULL)
        {
             SCARDHANDLE hReal = pReader->GetCardHandle();
             if(hReal > 0 && hReal == pAppReader->hOriginal)
             {
                 bRet = TRUE;
             }
        }
    }
    return bRet;
}

SCARDHANDLE CApplicationObject::GetOriginal(SCARDHANDLE hHandle)
{
    SCARDHANDLE hOri = 0;
    CReaderObject *pReader = NULL;
    CAppReaderObject *pAppReader = NULL;
    pAppReader = (CAppReaderObject *)m_oReaders.Lookup(hHandle);
    if(pAppReader != NULL)
    {
        pReader = pAppReader->pReader;
        if(pReader != NULL)
        {
             hOri = pAppReader->hOriginal;
        }
    }
    return hOri;
}

void CApplicationObject::AddRef()
{
    m_lRefCount++;
}

long CApplicationObject::ReleaseRef()
{
    if(m_lRefCount > 0)
    {
        m_lRefCount--;
    }
    return m_lRefCount;
}
