// CRLScheduler.h: interface for the CCRLScheduler class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CRLSCHEDULER_H__205BA3B6_3468_48C9_AC1F_BCA4BA5A0DA6__INCLUDED_)
#define AFX_CRLSCHEDULER_H__205BA3B6_3468_48C9_AC1F_BCA4BA5A0DA6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef _WIN32
#pragma warning(disable:4786)
#endif
#include <openssl/ssl.h>
#include <string>
#include <vector>

class CCRLScheduler : public CThread  
{
public:
	CCRLScheduler();
	virtual ~CCRLScheduler();

	void Tick (void);
protected:
    BIO *Connect(char *pszHost, int iPort, int iSSL, SSL_CTX **ppSSLCtx);
    BIO *ConnectSSL(char *pszHost, int iPort, SSL_CTX **ppSSLCtx);
    void *RetrieveWebdata(char *pszUri, int *piDataLen);
    void BuildCRLList();
    void CheckCRLList(char *pszHttpCRLStore);
    void FindLocalCRL(char *pszHttpCRLStore, char *pCRLDistribution);
    void RetrieveCRL(char *pszUri, char *pszFile);
    int VerifyCertHostname(X509 *pCert, char *pszHostname);


private:
    std::vector<std::string> m_oVecCRLList;
};

#endif // !defined(AFX_CRLSCHEDULER_H__205BA3B6_3468_48C9_AC1F_BCA4BA5A0DA6__INCLUDED_)
