// DefaultHandler.cpp: implementation of the CDefaultHandler class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "DefaultHandler.h"
#include "defines.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDefaultHandler::CDefaultHandler() : CMessageHandler ("DefaultHandler")
{
	SetMessageNameHandled ("DEFAULT_HANDLING");
}

CDefaultHandler::~CDefaultHandler()
{

}

void CDefaultHandler::Execute(void)
{
	long lReturn = SCARD_F_UNKNOWN_ERROR;
    
	Trace (__FILE__, __LINE__, LOGMASK_BELPIC_INFO, "CDefaultHandler::Execute - Begin");

	/* Now send back the notification message */
	((CGenericMessage*)m_Message)->AddValueForKey("Return", lReturn);

	Trace (__FILE__, __LINE__, LOGMASK_BELPIC_INFO, "CDefaultHandler::Execute - End");
}

CObject *CDefaultHandler::Clone (void)
{
	CDefaultHandler *tempObject = new CDefaultHandler();
	return (CObject *) tempObject;
}
