// PCSCManager.h: interface for the CPCSCManager class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PCSCMANAGER_H__ED195A11_33EC_4309_B422_33CF927E638A__INCLUDED_)
#define AFX_PCSCMANAGER_H__ED195A11_33EC_4309_B422_33CF927E638A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <wx/dynlib.h>

#ifdef BELPIC_PIN_PAD
typedef struct
{
    char szPinPadDll[256];
    wxDynamicLibrary *pDll;
} PinPadObject;
#endif

class CTransactionStack;
class CApplicationObject;

class CPCSCManager : public CManager 
{
public:
	CPCSCManager();
	virtual ~CPCSCManager();

    void Initialize();
    SCARDCONTEXT GetContextHandle();
    void EventCardState(unsigned long ulState, const char *pszReaderName);

    // Interface to MessageHandlers
    long S_CardEstablishContext(CGenericMessage *pMessage);
    long S_CardReleaseContext(CGenericMessage *pMessage);
    long S_CardConnect(CGenericMessage *pMessage);
    long S_CardDisconnect(CGenericMessage *pMessage);
    long S_CardStatus(CGenericMessage *pMessage);
    long S_CardListReaders(CGenericMessage *pMessage);
    long S_CardGetStatusChange(CGenericMessage *pMessage);
    long S_CardBeginTransaction(CGenericMessage *pMessage);
    long S_CardEndTransaction(CGenericMessage *pMessage);
    long S_CardTransmit(CGenericMessage *pMessage);
    long S_CardControl(CGenericMessage *pMessage);
    long S_CardControlPinPad(CGenericMessage *pMessage);

    BOOL Suspend();

protected:
//    BOOL CheckAccess(CApplicationObject* pApplication, BYTE *pSendBuffer, unsigned long ulSendLen);
#ifdef BELPIC_PIN_PAD
    long HandlePinPad(const void *lpInBuffer, DWORD nInBufferSize, void *lpOutBuffer, DWORD *lpBytesReturned, SCARDHANDLE hReal);
#endif

protected:
	PASS_SYNCH lock;
    SCARDCONTEXT m_hContext;
    CStringToObjectCollection m_Readers;
    CTransactionStack *m_pTransActionStack;
#ifdef BELPIC_PIN_PAD
    PinPadObject *m_pPinPadDlls;
#endif
};

#endif // !defined(AFX_PCSCMANAGER_H__ED195A11_33EC_4309_B422_33CF927E638A__INCLUDED_)
