// CardReader.h: interface for the CCardReader class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CARDREADER_H__AE0557F3_8313_4F7A_BCD7_8F6166618038__INCLUDED_)
#define AFX_CARDREADER_H__AE0557F3_8313_4F7A_BCD7_8F6166618038__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "eidlib.h"

#ifdef _WIN32
    #pragma warning(disable:4786)
#endif

#include <string>

class CCardReader  
{
public:
	CCardReader();
	virtual ~CCardReader();

    virtual const char *GetConnectedName() = 0;
    virtual long Connect(const char *pszReaderName, BEID_Status *ptStatus) = 0;
    virtual long Disconnect(BEID_Status *ptStatus) = 0;
    virtual long EstablishContext(BEID_Status *ptStatus) = 0;
    virtual long ReleaseContext(BEID_Status *ptStatus) = 0;
    virtual long GetHandle() = 0;
    virtual long BeginTransaction(BEID_Status *ptStatus) = 0;
    virtual long EndTransaction(BEID_Status *ptStatus) = 0;
    virtual long Transmit(const unsigned char *pucSend, int iSendLen, unsigned char *pucRecv, unsigned long *pulRecvLen, BEID_Status *ptStatus) = 0;
    virtual long ReadFile(const unsigned char *ucFile,  int iFileLen, unsigned char *pucOutput, unsigned long *pulOutLen, BEID_Status *ptStatus) = 0;
    virtual int CheckSW(BEID_Status *ptStatus) = 0;
    virtual long SelectFile(const unsigned char *ucFile, int iFileLen, unsigned char ucP1, BEID_Status *ptStatus) = 0;
    virtual long ReadBinary(unsigned char *pucOutput, unsigned long *pulOutLen, BEID_Status *ptStatus) = 0;
    virtual long UpdateBinary(unsigned char *pucInput, unsigned long ulInLen, BEID_Status *ptStatus) = 0;
    virtual long GetCardData(unsigned char *pucOutput, unsigned long *pulOutLen, bool bSigned, BEID_Status *ptStatus) = 0;
    virtual long GetPINStatus(unsigned char *pucOutput, unsigned long *pulOutLen, unsigned char ucPinReference, bool bSigned, BEID_Status *ptStatus) = 0;
    virtual long VerifyPIN(BEID_Pin *pPinData, const char *pszPin, long *piTriesLeft, BEID_Status *ptStatus) = 0;
    virtual long ChangePIN(BEID_Pin *pPinData, char *pszOldPin, char *pszNewPin, long *piTriesLeft, BEID_Status *ptStatus) = 0;
    virtual void *GetCard() = 0;
    virtual long ReadCachedFile(char *pszFile, BEID_Bytes *ptBytes) = 0;
    virtual long WriteCachedFile(char *pszFile, unsigned char *pucBytes, unsigned long ulLen) = 0;
    virtual long ReadCachedMemFile(char *pszFile, BEID_Bytes *ptBytes) = 0;
    virtual long WriteCachedMemFile(char *pszFile, unsigned char *pucBytes, unsigned long ulLen) = 0;
    virtual void FlushCache() = 0;
    virtual void SetRawData(BEID_Raw *pRawData) = 0;
    virtual long GetChallengeResponse(unsigned char *pucOutputCh, unsigned long *pulOutLenCh, 
        unsigned char *pucOutputResp, unsigned long *pulOutLenResp, BEID_Status *ptStatus) = 0;
};

#endif // !defined(AFX_CARDREADER_H__AE0557F3_8313_4F7A_BCD7_8F6166618038__INCLUDED_)
