// ObjectLock.cpp: implementation of the CObjectLock class.
//
//////////////////////////////////////////////////////////////////////

#include "ObjectLock.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CObjectLock::CObjectLock()
{
#ifdef _WIN32
    ::InitializeCriticalSection(&m_cs); 
#endif
}

CObjectLock::~CObjectLock()
{
#ifdef _WIN32
    ::DeleteCriticalSection(&m_cs);
#endif
}

void CObjectLock::Lock()
{
#ifdef _WIN32
    ::EnterCriticalSection(&m_cs);
#endif
}

void CObjectLock::Unlock()
{
#ifdef _WIN32
    ::LeaveCriticalSection(&m_cs);
#endif
}