/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include <stdio.h>
#include <getopt.h>
#include <opensc/pkcs11.h>

#define P11_LIB_NAME "Belgium Identity Card PKCS11"

#define N_TESTS	31

int c_Initialize();
int c_Finalize();
int c_GetInfo();
int c_GetFunctionList();
int c_GetSlotList();		// 5
int c_GetSlotInfo();
int c_GetTokenInfo();
int c_GetMechanismsList();
int c_GetMechanismInfo();
int c_WaitForSlotEvent();	// 10
int c_OpenSession();
int c_CloseSession();
int c_CloseAllSessions();
int c_GetSessionInfo();
int c_FindObjectsInit();	// 15
int c_FindObjects();
int c_FindObjectsFinal();
int c_GetAttributeValue();
int c_DigestInit();
int c_Digest();			// 20
int c_DigestUpdateFinal();
int c_SeedRandom();
int c_GenerateRandom();
int c_SetPin();
int c_Login();			// 25
int c_Logout();
int c_SignInit();
int c_Sign();
int c_SignUpdateFinal();

CK_SLOT_ID getFirstSlot(int tokenPresent);
CK_SESSION_HANDLE getSessionInFirstSlot();
CK_OBJECT_HANDLE find_object(CK_SESSION_HANDLE sess, CK_OBJECT_CLASS cls, int obj_index);
CK_BBOOL slotWithTokenIsPAP();

const char *CKR2Str(CK_ULONG res);

extern CK_FUNCTION_LIST_PTR p11;
