// TLVBuffer.h: interface for the CTLVBuffer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TLVBUFFER_H__E687DC32_54AD_4FE8_A520_2060F03D8729__INCLUDED_)
#define AFX_TLVBUFFER_H__E687DC32_54AD_4FE8_A520_2060F03D8729__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef _WIN32
    #pragma warning(disable:4786)
#endif

#include <map>
#include "TLV.h"

class CTLVBuffer  
{
public:
	CTLVBuffer();
	virtual ~CTLVBuffer();
    
    int ParseTLV(unsigned char *pucData, unsigned long ulLen);
    CTLV *GetTagData(unsigned char ucTag);
    void FillASCIIData(unsigned char ucTag, char *pData);
    void FillUTF8Data(unsigned char ucTag, char *pData);
    void FillBinaryStringData(unsigned char ucTag, char *pData);
    void FillIntData(unsigned char ucTag, int *piData);
    void FillLongData(unsigned char ucTag, long *piData);
    void FillBinaryData(unsigned char ucTag, unsigned char *pData, unsigned long *ulLength);
protected:
    char *Hexify(unsigned char * pData, unsigned long ulLen);
    int BytesToInt(unsigned char * pData, unsigned long ulLen);

private:
    static char hexChars[];
    std::map<unsigned char, CTLV *> m_oMapTLV;
    typedef std::map<unsigned char, CTLV *>::iterator ITMap;

};

#endif // !defined(AFX_TLVBUFFER_H__E687DC32_54AD_4FE8_A520_2060F03D8729__INCLUDED_)
