/*
 *        .þÛÛþ þ    þ þÛÛþ.     þ    þ þÛÛÛþ.  þÛÛÛþ .þÛÛþ. þ    þ
 *       .þ   Û Ûþ.  Û Û   þ.    Û    Û Û    þ  Û.    Û.   Û Ûþ.  Û
 *       Û    Û Û Û  Û Û    Û    Û   þ. Û.   Û  Û     Û    Û Û Û  Û
 *     .þþÛÛÛÛþ Û  Û Û þÛÛÛÛþþ.  þþÛÛ.  þþÛÛþ.  þÛ    Û    Û Û  Û Û
 *    .Û      Û Û  .þÛ Û      Û. Û   Û  Û    Û  Û.    þ.   Û Û  .þÛ
 *    þ.      þ þ    þ þ      .þ þ   .þ þ    .þ þÛÛÛþ .þÛÛþ. þ    þ
 *
 * Berusky (C) AnakreoN
 * Martin Stransky <stransky@anakreon.cz> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __MAIN_H__
#define __MAIN_H__

typedef enum game_mode {

  USER_LEVEL,
  USER_DEMO,
  MENU,
  EDITOR

} GAME_MODE;

extern int global_frame;

inline void delay(int msecs)
{
  SDL_Delay(msecs);
}

bool  graphics_game_load(DIR_LIST *p_dir);
void  graphics_game_free(void);

bool  graphics_menu_load(DIR_LIST *p_dir);
void  graphics_menu_free(void);

bool  graphics_logos_load(DIR_LIST *p_dir);
void  graphics_logos_free(void);

void  start_logo_draw(GAME_MODE mode);

#define PROGRESS_MOVE (-1)
void  start_logo_progress(int steps = PROGRESS_MOVE);

bool  repository_load(ITEM_REPOSITORY *p_repo, DIR_LIST *p_dir);

int   background_num(DIR_LIST *p_dir);

char *config_file(bool configure = FALSE);

void  user_directory_create(void);

#endif
