/*
 *
 * Beryl blur and reflection effect plugin
 *
 * blurfx_shader.h
 *
 * Copyright : (C) 2006 by Dennis Kasprzyk
 * E-mail    : onestone@beryl-project.org
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Cg sources can be found in shaders
 */

#ifndef blurfx_SHADER_H
#define blurfx_SHADER_H

static const char* gaussian9x9_H =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[3] = { { 3.310219, 0, 0.091073997, 1.39698 },\n"
	"		{ 0.30337501, 0.21110199, -3.310219, 0 },\n"
	"		{ -1.39698, 0 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[2].xyyy, fragment.texcoord[0];\n"
	"TXP R1, R0, texture[0], RECT;\n"
	"MAD R0, fragment.texcoord[0].w, c[1].zwww, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MUL R1, R1, c[1].x;\n"
	"MAD R1, R0, c[0].z, R1;\n"
	"TXP R0, fragment.texcoord[0], texture[0], RECT;\n"
	"MAD R2, R0, c[1].y, R1;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].wyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[1].x, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* gaussian9x9_V =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[3] = { { 0, 3.310219, 0.091073997, 1.39698 },\n"
	"		{ 0.30337501, 0.21110199, 0, -3.310219 },\n"
	"		{ 0, -1.39698 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[2].xyxx, fragment.texcoord[0];\n"
	"TXP R1, R0, texture[0], RECT;\n"
	"MAD R0, fragment.texcoord[0].w, c[1].zwzz, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MUL R1, R1, c[1].x;\n"
	"MAD R1, R0, c[0].z, R1;\n"
	"TXP R0, fragment.texcoord[0], texture[0], RECT;\n"
	"MAD R2, R0, c[1].y, R1;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].xwxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyxx, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[1].x, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* gaussian17x17_V =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[5] = { { 0, 7.300571, 0.0061269999, 5.3142352 },\n"
	"		{ 0.031213, 0, 3.361583, 0.118315 },\n"
	"		{ 0, 1.436257, 0.26341599, 0.16185699 },\n"
	"		{ 0, -1.436257, -3.361583, -7.300571 },\n"
	"		{ 0, -5.3142352 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[4].xyxx, fragment.texcoord[0];\n"
	"TXP R1, R0, texture[0], RECT;\n"
	"MAD R0, fragment.texcoord[0].w, c[3].xwxx, fragment.texcoord[0];\n"
	"MUL R1, R1, c[1].x;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R2, R0, c[0].z, R1;\n"
	"MAD R0, fragment.texcoord[0].w, c[3].xzxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[3].xyxx, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[1].w, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R1, R1, c[2].z, R0;\n"
	"TXP R0, fragment.texcoord[0], texture[0], RECT;\n"
	"MAD R2, R0, c[2].w, R1;\n"
	"MAD R0, fragment.texcoord[0].w, c[2].xyxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[1].yzyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[2].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[1].w, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].xwxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyxx, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[1].x, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* gaussian17x17_H =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[5] = { { 7.300571, 0, 0.0061269999, 5.3142352 },\n"
	"		{ 0.031213, 3.361583, 0, 0.118315 },\n"
	"		{ 1.436257, 0, 0.26341599, 0.16185699 },\n"
	"		{ -1.436257, 0, -3.361583, -7.300571 },\n"
	"		{ -5.3142352, 0 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[4].xyyy, fragment.texcoord[0];\n"
	"TXP R1, R0, texture[0], RECT;\n"
	"MAD R0, fragment.texcoord[0].w, c[3].wyyy, fragment.texcoord[0];\n"
	"MUL R1, R1, c[1].x;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R2, R0, c[0].z, R1;\n"
	"MAD R0, fragment.texcoord[0].w, c[3].zyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[3].xyyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[1].w, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R1, R1, c[2].z, R0;\n"
	"TXP R0, fragment.texcoord[0], texture[0], RECT;\n"
	"MAD R2, R0, c[2].w, R1;\n"
	"MAD R0, fragment.texcoord[0].w, c[2].xyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[1].yzzz, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[2].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[1].w, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].wyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[1].x, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* gaussian5x5_H =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[2] = { { 1.347705, 0, 0.354886, -1.347705 },\n"
	"		{ 0.290227 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyyy, fragment.texcoord[0];\n"
	"TXP R2, fragment.texcoord[0], texture[0], RECT;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].wyyy, fragment.texcoord[0];\n"
	"MUL R2, R2, c[1].x;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* gaussian21x21_H =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[6] = { { 9.3001366, 0, 0.001594, 7.3051109 },\n"
	"		{ 0.0084830001, 5.3300581, 0, 0.038972002 },\n"
	"		{ 3.380198, 0, 0.126184, 1.446185 },\n"
	"		{ 0.25026399, 0.14900599, -1.446185, 0 },\n"
	"		{ -3.380198, 0, -5.3300581, -9.3001366 },\n"
	"		{ -7.3051109, 0 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[5].xyyy, fragment.texcoord[0];\n"
	"TXP R2, R0, texture[0], RECT;\n"
	"MAD R1, fragment.texcoord[0].w, c[4].zyyy, fragment.texcoord[0];\n"
	"MAD R0, fragment.texcoord[0].w, c[4].wyyy, fragment.texcoord[0];\n"
	"MUL R2, R2, c[1].x;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[1].w, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[4].xyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[3].zwww, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[2].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[3].x, R0;\n"
	"MAD R1, fragment.texcoord[0].w, c[2].wyyy, fragment.texcoord[0];\n"
	"TXP R0, fragment.texcoord[0], texture[0], RECT;\n"
	"MAD R0, R0, c[3].y, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[3].x, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[2].xyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[1].yzzz, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[2].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[1].w, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].wyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[1].x, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* linear17x17_H =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[4] = { { 7.5, 0, 0.117647, 5.5 },\n"
	"		{ 3.5, 0, 1.5, -7.5 },\n"
	"		{ -5.5, 0, -3.5, -1.5 },\n"
	"		{ 0.058823999 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[2].zyyy, fragment.texcoord[0];\n"
	"TXP R2, R0, texture[0], RECT;\n"
	"MAD R1, fragment.texcoord[0].w, c[2].xyyy, fragment.texcoord[0];\n"
	"MAD R0, fragment.texcoord[0].w, c[1].wyyy, fragment.texcoord[0];\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"ADD R2, R0, R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[2].wyyy, fragment.texcoord[0];\n"
	"TXP R1, fragment.texcoord[0], texture[0], RECT;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"ADD R0, R2, R0;\n"
	"MUL R1, R1, c[3].x;\n"
	"MAD R2, R0, c[0].z, R1;\n"
	"MAD R0, fragment.texcoord[0].w, c[1].zyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[1].xyyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[0].z, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].wyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* linear5x5_V =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[2] = { { 0, 1.5, 0.40000001, -1.5 },\n"
	"		{ 0.2 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyxx, fragment.texcoord[0];\n"
	"TXP R2, fragment.texcoord[0], texture[0], RECT;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].xwxx, fragment.texcoord[0];\n"
	"MUL R2, R2, c[1].x;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* linear9x9_V =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[2] = { { 0, 3.5, 0.222222, 1.5 },\n"
	"		{ 0, -3.5, -1.5, 0.111111 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"TXP R0, fragment.texcoord[0], texture[0], RECT;\n"
	"MUL R2, R0, c[1].w;\n"
	"MAD R1, fragment.texcoord[0].w, c[1].xzxx, fragment.texcoord[0];\n"
	"MAD R0, fragment.texcoord[0].w, c[1].xyxx, fragment.texcoord[0];\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"MAD R2, R0, c[0].z, R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].xwxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyxx, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* gaussian5x5_V =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[2] = { { 0, 1.347705, 0.354886, -1.347705 },\n"
	"		{ 0.290227 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyxx, fragment.texcoord[0];\n"
	"TXP R2, fragment.texcoord[0], texture[0], RECT;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].xwxx, fragment.texcoord[0];\n"
	"MUL R2, R2, c[1].x;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* linear5x5_H =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[2] = { { 1.5, 0, 0.40000001, -1.5 },\n"
	"		{ 0.2 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyyy, fragment.texcoord[0];\n"
	"TXP R2, fragment.texcoord[0], texture[0], RECT;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].wyyy, fragment.texcoord[0];\n"
	"MUL R2, R2, c[1].x;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* linear13x13_H =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[3] = { { 5.5, 0, 0.153846, 3.5 },\n"
	"		{ 1.5, 0, -5.5, -3.5 },\n"
	"		{ -1.5, 0, 0.076922998 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R1, fragment.texcoord[0].w, c[1].wyyy, fragment.texcoord[0];\n"
	"MAD R0, fragment.texcoord[0].w, c[1].zyyy, fragment.texcoord[0];\n"
	"MAD R2, fragment.texcoord[0].w, c[2].xyyy, fragment.texcoord[0];\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"TXP R1, R2, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"TXP R2, fragment.texcoord[0], texture[0], RECT;\n"
	"MUL R2, R2, c[2].z;\n"
	"MAD R1, fragment.texcoord[0].w, c[1].xyyy, fragment.texcoord[0];\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[0].z, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].wyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* linear13x13_V =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[3] = { { 0, 5.5, 0.153846, 3.5 },\n"
	"		{ 0, 1.5, -5.5, -3.5 },\n"
	"		{ 0, -1.5, 0.076922998 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R1, fragment.texcoord[0].w, c[1].xwxx, fragment.texcoord[0];\n"
	"MAD R0, fragment.texcoord[0].w, c[1].xzxx, fragment.texcoord[0];\n"
	"MAD R2, fragment.texcoord[0].w, c[2].xyxx, fragment.texcoord[0];\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"TXP R1, R2, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"TXP R2, fragment.texcoord[0], texture[0], RECT;\n"
	"MUL R2, R2, c[2].z;\n"
	"MAD R1, fragment.texcoord[0].w, c[1].xyxx, fragment.texcoord[0];\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[0].z, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].xwxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyxx, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* gaussian13x13_V =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[4] = { { 0, 5.302392, 0.023582, 3.3376839 },\n"
	"		{ 0.106752, 0, 1.4214931, 0.27964401 },\n"
	"		{ 0.180044, 0, -1.4214931, -5.302392 },\n"
	"		{ 0, -3.3376839 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[3].xyxx, fragment.texcoord[0];\n"
	"TXP R2, R0, texture[0], RECT;\n"
	"MAD R1, fragment.texcoord[0].w, c[2].yzyy, fragment.texcoord[0];\n"
	"MAD R0, fragment.texcoord[0].w, c[2].ywyy, fragment.texcoord[0];\n"
	"MUL R2, R2, c[1].x;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[1].w, R0;\n"
	"MAD R1, fragment.texcoord[0].w, c[1].yzyy, fragment.texcoord[0];\n"
	"TXP R0, fragment.texcoord[0], texture[0], RECT;\n"
	"MAD R0, R0, c[2].x, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[1].w, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].xwxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyxx, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[1].x, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* gaussian13x13_H =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[4] = { { 5.302392, 0, 0.023582, 3.3376839 },\n"
	"		{ 0.106752, 1.4214931, 0, 0.27964401 },\n"
	"		{ 0.180044, -1.4214931, 0, -5.302392 },\n"
	"		{ -3.3376839, 0 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[3].xyyy, fragment.texcoord[0];\n"
	"TXP R2, R0, texture[0], RECT;\n"
	"MAD R1, fragment.texcoord[0].w, c[2].yzzz, fragment.texcoord[0];\n"
	"MAD R0, fragment.texcoord[0].w, c[2].wzzz, fragment.texcoord[0];\n"
	"MUL R2, R2, c[1].x;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[1].w, R0;\n"
	"MAD R1, fragment.texcoord[0].w, c[1].yzzz, fragment.texcoord[0];\n"
	"TXP R0, fragment.texcoord[0], texture[0], RECT;\n"
	"MAD R0, R0, c[2].x, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[1].w, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].wyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[1].x, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* linear17x17_V =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[4] = { { 0, 7.5, 0.117647, 5.5 },\n"
	"		{ 0, 3.5, 1.5, -7.5 },\n"
	"		{ 0, -5.5, -3.5, -1.5 },\n"
	"		{ 0.058823999 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[2].xzxx, fragment.texcoord[0];\n"
	"TXP R2, R0, texture[0], RECT;\n"
	"MAD R1, fragment.texcoord[0].w, c[2].xyxx, fragment.texcoord[0];\n"
	"MAD R0, fragment.texcoord[0].w, c[1].xwxx, fragment.texcoord[0];\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"ADD R2, R0, R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[2].xwxx, fragment.texcoord[0];\n"
	"TXP R1, fragment.texcoord[0], texture[0], RECT;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"ADD R0, R2, R0;\n"
	"MUL R1, R1, c[3].x;\n"
	"MAD R2, R0, c[0].z, R1;\n"
	"MAD R0, fragment.texcoord[0].w, c[1].xzxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[1].xyxx, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[0].z, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].xwxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyxx, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* linear9x9_H =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[2] = { { 3.5, 0, 0.222222, 1.5 },\n"
	"		{ -3.5, 0, -1.5, 0.111111 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"TXP R0, fragment.texcoord[0], texture[0], RECT;\n"
	"MUL R2, R0, c[1].w;\n"
	"MAD R1, fragment.texcoord[0].w, c[1].zyyy, fragment.texcoord[0];\n"
	"MAD R0, fragment.texcoord[0].w, c[1].xyyy, fragment.texcoord[0];\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"MAD R2, R0, c[0].z, R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].wyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* linear21x21_H =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[4] = { { 9.5, 0, 0.095238, 7.5 },\n"
	"		{ 5.5, 0, 3.5, 1.5 },\n"
	"		{ -9.5, 0, -7.5, -5.5 },\n"
	"		{ -3.5, 0, -1.5, 0.047619 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R1, fragment.texcoord[0].w, c[2].zyyy, fragment.texcoord[0];\n"
	"MAD R0, fragment.texcoord[0].w, c[2].xyyy, fragment.texcoord[0];\n"
	"MAD R2, fragment.texcoord[0].w, c[2].wyyy, fragment.texcoord[0];\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"TXP R1, R2, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"MAD R2, fragment.texcoord[0].w, c[3].xyyy, fragment.texcoord[0];\n"
	"TXP R1, R2, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"MAD R2, fragment.texcoord[0].w, c[3].zyyy, fragment.texcoord[0];\n"
	"TXP R1, R2, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"TXP R2, fragment.texcoord[0], texture[0], RECT;\n"
	"MUL R2, R2, c[3].w;\n"
	"MAD R1, fragment.texcoord[0].w, c[1].wyyy, fragment.texcoord[0];\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[0].z, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[1].zyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[1].xyyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[0].z, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].wyyy, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* linear21x21_V =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[4] = { { 0, 9.5, 0.095238, 7.5 },\n"
	"		{ 0, 5.5, 3.5, 1.5 },\n"
	"		{ 0, -9.5, -7.5, -5.5 },\n"
	"		{ 0, -3.5, -1.5, 0.047619 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R1, fragment.texcoord[0].w, c[2].xzxx, fragment.texcoord[0];\n"
	"MAD R0, fragment.texcoord[0].w, c[2].xyxx, fragment.texcoord[0];\n"
	"MAD R2, fragment.texcoord[0].w, c[2].xwxx, fragment.texcoord[0];\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"TXP R1, R2, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"MAD R2, fragment.texcoord[0].w, c[3].xyxx, fragment.texcoord[0];\n"
	"TXP R1, R2, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"MAD R2, fragment.texcoord[0].w, c[3].xzxx, fragment.texcoord[0];\n"
	"TXP R1, R2, texture[0], RECT;\n"
	"ADD R0, R0, R1;\n"
	"TXP R2, fragment.texcoord[0], texture[0], RECT;\n"
	"MUL R2, R2, c[3].w;\n"
	"MAD R1, fragment.texcoord[0].w, c[1].xwxx, fragment.texcoord[0];\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[0].z, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[1].xzxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[1].xyxx, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[0].z, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].xwxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyxx, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

static const char* gaussian21x21_V =
	"!!ARBfp1.0\n"
	"OPTION ARB_precision_hint_fastest;\n"
	"PARAM c[6] = { { 0, 9.3001366, 0.001594, 7.3051109 },\n"
	"		{ 0.0084830001, 0, 5.3300581, 0.038972002 },\n"
	"		{ 0, 3.380198, 0.126184, 1.446185 },\n"
	"		{ 0.25026399, 0.14900599, 0, -1.446185 },\n"
	"		{ 0, -3.380198, -5.3300581, -9.3001366 },\n"
	"		{ 0, -7.3051109 } };\n"
	"TEMP R0;\n"
	"TEMP R1;\n"
	"TEMP R2;\n"
	"MAD R0, fragment.texcoord[0].w, c[5].xyxx, fragment.texcoord[0];\n"
	"TXP R2, R0, texture[0], RECT;\n"
	"MAD R1, fragment.texcoord[0].w, c[4].xzxx, fragment.texcoord[0];\n"
	"MAD R0, fragment.texcoord[0].w, c[4].xwxx, fragment.texcoord[0];\n"
	"MUL R2, R2, c[1].x;\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[0].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[1].w, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[4].xyxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[3].zwzz, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[2].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[3].x, R0;\n"
	"MAD R1, fragment.texcoord[0].w, c[2].xwxx, fragment.texcoord[0];\n"
	"TXP R0, fragment.texcoord[0], texture[0], RECT;\n"
	"MAD R0, R0, c[3].y, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[3].x, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[2].xyxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[1].yzyy, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[2].z, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD R2, R1, c[1].w, R0;\n"
	"MAD R0, fragment.texcoord[0].w, c[0].xwxx, fragment.texcoord[0];\n"
	"MAD R1, fragment.texcoord[0].w, c[0].xyxx, fragment.texcoord[0];\n"
	"TXP R0, R0, texture[0], RECT;\n"
	"MAD R0, R0, c[1].x, R2;\n"
	"TXP R1, R1, texture[0], RECT;\n"
	"MAD result.color, R1, c[0].z, R0;\n"
	"END\n"
;

#endif
