/* json_soup.c generated by valac 0.12.0, the Vala compiler
 * generated from json_soup.vala, do not modify */

/* -*- coding: utf-8; indent-tabs-mode: nil; tab-width: 4; c-basic-offset: 4; -*- */
/* vim:set fileencodings=utf-8 tabstop=4 expandtab shiftwidth=4 softtabstop=4: */

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <float.h>
#include <math.h>


#define TYPE_JSON_SOUP (json_soup_get_type ())
#define JSON_SOUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_JSON_SOUP, JsonSoup))
#define JSON_SOUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_JSON_SOUP, JsonSoupClass))
#define IS_JSON_SOUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_JSON_SOUP))
#define IS_JSON_SOUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_JSON_SOUP))
#define JSON_SOUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_JSON_SOUP, JsonSoupClass))

typedef struct _JsonSoup JsonSoup;
typedef struct _JsonSoupClass JsonSoupClass;
typedef struct _JsonSoupPrivate JsonSoupPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _soup_uri_free0(var) ((var == NULL) ? NULL : (var = (soup_uri_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

struct _JsonSoup {
	GObject parent_instance;
	JsonSoupPrivate * priv;
};

struct _JsonSoupClass {
	GObjectClass parent_class;
};

struct _JsonSoupPrivate {
	JsonParser* parser;
	JsonNode* node;
};


static gpointer json_soup_parent_class = NULL;

GType json_soup_get_type (void) G_GNUC_CONST;
#define JSON_SOUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_JSON_SOUP, JsonSoupPrivate))
enum  {
	JSON_SOUP_DUMMY_PROPERTY
};
JsonSoup* json_soup_new_buffer (const gchar* buffer);
JsonSoup* json_soup_construct_buffer (GType object_type, const gchar* buffer);
JsonSoup* json_soup_new_file (const gchar* file);
JsonSoup* json_soup_construct_file (GType object_type, const gchar* file);
JsonSoup* json_soup_new_http (const gchar* url);
JsonSoup* json_soup_construct_http (GType object_type, const gchar* url);
JsonSoup* json_soup_object (JsonSoup* self, const gchar* name);
JsonSoup* json_soup_sibling (JsonSoup* self, const gchar* name);
JsonSoup* json_soup_parent (JsonSoup* self);
JsonSoup* json_soup_array (JsonSoup* self, gint idx);
JsonSoup* json_soup_grandparent (JsonSoup* self);
JsonSoup* json_soup_reset (JsonSoup* self);
static gboolean json_soup_is_value (JsonSoup* self);
gboolean json_soup_is_object (JsonSoup* self);
gboolean json_soup_is_array (JsonSoup* self);
gboolean json_soup_is_string (JsonSoup* self);
gboolean json_soup_is_int (JsonSoup* self);
gboolean json_soup_is_double (JsonSoup* self);
gboolean json_soup_is_bool (JsonSoup* self);
gchar* json_soup_get_string (JsonSoup* self);
gint64 json_soup_get_int (JsonSoup* self);
gdouble json_soup_get_double (JsonSoup* self);
gboolean json_soup_get_bool (JsonSoup* self);
gint json_soup_length (JsonSoup* self);
JsonSoup* json_soup_new (void);
JsonSoup* json_soup_construct (GType object_type);
static void json_soup_finalize (GObject* obj);


JsonSoup* json_soup_construct_buffer (GType object_type, const gchar* buffer) {
	JsonSoup * self = NULL;
	JsonParser* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (buffer != NULL, NULL);
	self = (JsonSoup*) g_object_new (object_type, NULL);
	_tmp0_ = json_parser_new ();
	_g_object_unref0 (self->priv->parser);
	self->priv->parser = _tmp0_;
	json_parser_load_from_data (self->priv->parser, buffer, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	_tmp1_ = json_parser_get_root (self->priv->parser);
	self->priv->node = _tmp1_;
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("json_soup.vala:34: %s", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


JsonSoup* json_soup_new_buffer (const gchar* buffer) {
	return json_soup_construct_buffer (TYPE_JSON_SOUP, buffer);
}


JsonSoup* json_soup_construct_file (GType object_type, const gchar* file) {
	JsonSoup * self = NULL;
	JsonParser* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (JsonSoup*) g_object_new (object_type, NULL);
	_tmp0_ = json_parser_new ();
	_g_object_unref0 (self->priv->parser);
	self->priv->parser = _tmp0_;
	json_parser_load_from_file (self->priv->parser, file, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	_tmp1_ = json_parser_get_root (self->priv->parser);
	self->priv->node = _tmp1_;
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("json_soup.vala:43: %s", e->message);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


JsonSoup* json_soup_new_file (const gchar* file) {
	return json_soup_construct_file (TYPE_JSON_SOUP, file);
}


JsonSoup* json_soup_construct_http (GType object_type, const gchar* url) {
	JsonSoup * self = NULL;
	SoupSessionAsync* _tmp0_ = NULL;
	SoupSessionAsync* session;
	SoupURI* _tmp1_ = NULL;
	SoupURI* _tmp2_;
	SoupMessage* _tmp3_ = NULL;
	SoupMessage* _tmp4_;
	SoupMessage* message;
	guint _tmp5_;
	JsonParser* _tmp6_ = NULL;
	JsonNode* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (url != NULL, NULL);
	self = (JsonSoup*) g_object_new (object_type, NULL);
	_tmp0_ = (SoupSessionAsync*) soup_session_async_new ();
	session = _tmp0_;
	_tmp1_ = soup_uri_new (url);
	_tmp2_ = _tmp1_;
	_tmp3_ = soup_message_new_from_uri ("GET", _tmp2_);
	_tmp4_ = _tmp3_;
	_soup_uri_free0 (_tmp2_);
	message = _tmp4_;
	_tmp5_ = soup_session_send_message ((SoupSession*) session, message);
	if (_tmp5_ != 200) {
		g_warning ("json_soup.vala:50: Can not connect to %s", url);
	}
	_tmp6_ = json_parser_new ();
	_g_object_unref0 (self->priv->parser);
	self->priv->parser = _tmp6_;
	json_parser_load_from_data (self->priv->parser, (const gchar*) message->response_body->data, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	_tmp7_ = json_parser_get_root (self->priv->parser);
	self->priv->node = _tmp7_;
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("json_soup.vala:57: %s", e->message);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (message);
	_g_object_unref0 (session);
	return self;
}


JsonSoup* json_soup_new_http (const gchar* url) {
	return json_soup_construct_http (TYPE_JSON_SOUP, url);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


JsonSoup* json_soup_object (JsonSoup* self, const gchar* name) {
	JsonSoup* result = NULL;
	JsonNodeType _tmp0_;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_;
	JsonObject* object;
	gboolean _tmp3_;
	JsonNode* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = json_node_get_node_type (self->priv->node);
	if (_tmp0_ != JSON_NODE_OBJECT) {
		g_warning ("json_soup.vala:70: This is not a object.");
		result = self;
		return result;
	}
	_tmp1_ = json_node_get_object (self->priv->node);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	object = _tmp2_;
	_tmp3_ = json_object_has_member (object, name);
	if (_tmp3_ == FALSE) {
		g_warning ("json_soup.vala:75: There is no such member as %s.", name);
		result = self;
		_json_object_unref0 (object);
		return result;
	}
	_tmp4_ = json_object_get_member (object, name);
	self->priv->node = _tmp4_;
	result = self;
	_json_object_unref0 (object);
	return result;
}


JsonSoup* json_soup_sibling (JsonSoup* self, const gchar* name) {
	JsonSoup* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	json_soup_parent (self);
	json_soup_object (self, name);
	result = self;
	return result;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


JsonSoup* json_soup_array (JsonSoup* self, gint idx) {
	JsonSoup* result = NULL;
	JsonNodeType _tmp0_;
	JsonArray* _tmp1_ = NULL;
	JsonArray* _tmp2_;
	JsonArray* array;
	guint _tmp3_;
	gint length;
	gboolean _tmp4_ = FALSE;
	JsonNode* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = json_node_get_node_type (self->priv->node);
	if (_tmp0_ != JSON_NODE_ARRAY) {
		g_warning ("json_soup.vala:88: This is not a array.");
		result = self;
		return result;
	}
	_tmp1_ = json_node_get_array (self->priv->node);
	_tmp2_ = _json_array_ref0 (_tmp1_);
	array = _tmp2_;
	_tmp3_ = json_array_get_length (array);
	length = (gint) _tmp3_;
	if (idx > length) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = idx < 0;
	}
	if (_tmp4_) {
		g_warning ("json_soup.vala:94: Out of index. %d", idx);
		result = self;
		_json_array_unref0 (array);
		return result;
	}
	_tmp5_ = json_array_get_element (array, (guint) idx);
	self->priv->node = _tmp5_;
	result = self;
	_json_array_unref0 (array);
	return result;
}


JsonSoup* json_soup_parent (JsonSoup* self) {
	JsonSoup* result = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonNode* parent_node;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = json_node_get_parent (self->priv->node);
	parent_node = _tmp0_;
	if (parent_node == NULL) {
		g_warning ("json_soup.vala:103: Already be root.");
		result = self;
		return result;
	}
	self->priv->node = parent_node;
	result = self;
	return result;
}


JsonSoup* json_soup_grandparent (JsonSoup* self) {
	JsonSoup* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	json_soup_parent (self);
	json_soup_parent (self);
	result = self;
	return result;
}


JsonSoup* json_soup_reset (JsonSoup* self) {
	JsonSoup* result = NULL;
	JsonNode* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = json_parser_get_root (self->priv->parser);
	self->priv->node = _tmp0_;
	result = self;
	return result;
}


static gboolean json_soup_is_value (JsonSoup* self) {
	gboolean result = FALSE;
	JsonNodeType _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = json_node_get_node_type (self->priv->node);
	if (_tmp0_ == JSON_NODE_VALUE) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


gboolean json_soup_is_object (JsonSoup* self) {
	gboolean result = FALSE;
	JsonNodeType _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = json_node_get_node_type (self->priv->node);
	result = _tmp0_ == JSON_NODE_OBJECT;
	return result;
}


gboolean json_soup_is_array (JsonSoup* self) {
	gboolean result = FALSE;
	JsonNodeType _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = json_node_get_node_type (self->priv->node);
	result = _tmp0_ == JSON_NODE_ARRAY;
	return result;
}


gboolean json_soup_is_string (JsonSoup* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = json_soup_is_value (self);
	if (_tmp0_ == FALSE) {
		result = FALSE;
		return result;
	}
	_tmp1_ = json_node_get_value_type (self->priv->node);
	result = _tmp1_ == G_TYPE_STRING;
	return result;
}


gboolean json_soup_is_int (JsonSoup* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = json_soup_is_value (self);
	if (_tmp0_ == FALSE) {
		result = FALSE;
		return result;
	}
	_tmp1_ = json_node_get_value_type (self->priv->node);
	result = _tmp1_ == G_TYPE_INT64;
	return result;
}


gboolean json_soup_is_double (JsonSoup* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = json_soup_is_value (self);
	if (_tmp0_ == FALSE) {
		result = FALSE;
		return result;
	}
	_tmp1_ = json_node_get_value_type (self->priv->node);
	result = _tmp1_ == G_TYPE_DOUBLE;
	return result;
}


gboolean json_soup_is_bool (JsonSoup* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = json_soup_is_value (self);
	if (_tmp0_ == FALSE) {
		result = FALSE;
		return result;
	}
	_tmp1_ = json_node_get_value_type (self->priv->node);
	result = _tmp1_ == G_TYPE_BOOLEAN;
	return result;
}


gchar* json_soup_get_string (JsonSoup* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = json_node_get_string (self->priv->node);
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gint64 json_soup_get_int (JsonSoup* self) {
	gint64 result = 0LL;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = json_node_get_int (self->priv->node);
	result = _tmp0_;
	return result;
}


gdouble json_soup_get_double (JsonSoup* self) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = json_node_get_double (self->priv->node);
	result = _tmp0_;
	return result;
}


gboolean json_soup_get_bool (JsonSoup* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = json_node_get_boolean (self->priv->node);
	result = _tmp0_;
	return result;
}


gint json_soup_length (JsonSoup* self) {
	gint result = 0;
	gboolean _tmp0_;
	JsonArray* _tmp1_ = NULL;
	JsonArray* _tmp2_;
	JsonArray* array;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = json_soup_is_array (self);
	if (_tmp0_ == FALSE) {
		result = 0;
		return result;
	}
	_tmp1_ = json_node_get_array (self->priv->node);
	_tmp2_ = _json_array_ref0 (_tmp1_);
	array = _tmp2_;
	_tmp3_ = json_array_get_length (array);
	result = (gint) _tmp3_;
	_json_array_unref0 (array);
	return result;
}


JsonSoup* json_soup_construct (GType object_type) {
	JsonSoup * self = NULL;
	self = (JsonSoup*) g_object_new (object_type, NULL);
	return self;
}


JsonSoup* json_soup_new (void) {
	return json_soup_construct (TYPE_JSON_SOUP);
}


static void json_soup_class_init (JsonSoupClass * klass) {
	json_soup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (JsonSoupPrivate));
	G_OBJECT_CLASS (klass)->finalize = json_soup_finalize;
}


static void json_soup_instance_init (JsonSoup * self) {
	self->priv = JSON_SOUP_GET_PRIVATE (self);
	self->priv->parser = NULL;
	self->priv->node = NULL;
}


static void json_soup_finalize (GObject* obj) {
	JsonSoup * self;
	self = JSON_SOUP (obj);
	self->priv->node = NULL;
	_g_object_unref0 (self->priv->parser);
	self->priv->parser = NULL;
	_g_object_unref0 (self->priv->parser);
	G_OBJECT_CLASS (json_soup_parent_class)->finalize (obj);
}


/**
 * Copyright (C) 2010 Shih-Yuan Lee (FourDollars) <fourdollars@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
GType json_soup_get_type (void) {
	static volatile gsize json_soup_type_id__volatile = 0;
	if (g_once_init_enter (&json_soup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (JsonSoupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) json_soup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JsonSoup), 0, (GInstanceInitFunc) json_soup_instance_init, NULL };
		GType json_soup_type_id;
		json_soup_type_id = g_type_register_static (G_TYPE_OBJECT, "JsonSoup", &g_define_type_info, 0);
		g_once_init_leave (&json_soup_type_id__volatile, json_soup_type_id);
	}
	return json_soup_type_id__volatile;
}



