/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef FILTERINGSERVER_H_
#define FILTERINGSERVER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Server.h"
#include "CraftedResponseGenerator.h"
#include <memory>

class HttpRequestMetadata;
class FilterTryList;
class RegexFilterDescriptor;
class RequestTag;
class State;
class URI;

class FilteringServer : public Server
{
public:
	FilteringServer(ServiceContext& context, ServerTimeouts const& timeouts);
	
	virtual ~FilteringServer();
	
	virtual IntrusivePtr<AbstractRequestHandler> submitRequest(
		ConstRequestPtr const& request_metadata,
		RequestTag const& request_tag,
		IntrusivePtr<AbstractResponseHandler> const& handler);
private:
	class ImageSubstitutionParser;
	class FlashSubstitutionParser;
	
	IntrusivePtr<AbstractRequestHandler> processSubstitutionRequest(
		ConstRequestPtr const& request_metadata,
		RequestTag const& request_tag,
		IntrusivePtr<AbstractResponseHandler> const& handler);
	
	IntrusivePtr<AbstractRequestHandler> processUrlPatterns(
		ConstRequestPtr const& request_metadata,
		RequestTag const& request_tag,
		IntrusivePtr<AbstractResponseHandler> const& handler);
	
	IntrusivePtr<AbstractRequestHandler> processAnalyzeRequest(
		ConstRequestPtr const& request_metadata,
		RequestTag const& request_tag,
		IntrusivePtr<AbstractResponseHandler> const& handler);
	
	void applyStandardFilters(FilterTryList& filters, URI const& request_url);
	
	static bool isFilteringEnabledForURL(State const& state, URI const& url);
};

#endif
