/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpRequestLine.h"
#include <ostream>

using namespace std;

HttpRequestLine::HttpRequestLine(BString const& method, URI const& uri, HttpVersion const& http_version)
:	m_method(method),
	m_uri(uri),
	m_httpVersion(http_version)
{
}

void
HttpRequestLine::toStream(std::ostream& strm, bool relative_url) const
{
	strm << m_method << ' ';
	m_uri.toStream(strm, relative_url ? URI::S_RELATIVE : URI::S_DEFAULT);
	strm << ' ' << m_httpVersion << "\r\n";
}
