/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ProxyDescriptor.h"

using namespace std;

ProxyDescriptor::ProxyDescriptor(SymbolicInetAddr const& addr)
:	m_addr(addr)
{
}

ProxyDescriptor::ProxyDescriptor(std::string const& config_problem)
:	m_addr("", -1),
	m_configProblem(config_problem)
{
}

ProxyDescriptor::ProxyDescriptor(ProxyDescriptor const& other)
:	m_addr(other.m_addr),
	m_configProblem(other.m_configProblem)
{
}

ProxyDescriptor::~ProxyDescriptor()
{
}

ProxyDescriptor&
ProxyDescriptor::operator=(ProxyDescriptor const& other)
{
	ProxyDescriptor(other).swap(*this);
	return *this;
}

void
ProxyDescriptor::swap(ProxyDescriptor& other)
{
	m_addr.swap(other.m_addr);
	m_configProblem.swap(other.m_configProblem);
}
