/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SYMBOLICINETADDR_H_
#define SYMBOLICINETADDR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <iosfwd>

class SymbolicInetAddr
{
public:
	SymbolicInetAddr(std::string const& host, int port)
	: m_host(host), m_port(port) {}
	
	std::string const& getHost() const { return m_host; }
	
	void setHost(std::string const& host) { m_host = host; }
	
	int getPort() const { return m_port; }
	
	void setPort(int port) { m_port = port; }
	
	void set(std::string const& host, int port) { m_host = host; m_port = port; }
	
	void swap(SymbolicInetAddr& other);
	
	void toStream(std::ostream& strm) const;
	
	bool operator==(SymbolicInetAddr const& other) const;
	
	bool operator!=(SymbolicInetAddr const& other) const;
	
	bool operator<(SymbolicInetAddr const& rhs) const;
	
	bool operator<=(SymbolicInetAddr const& rhs) const;
	
	bool operator>(SymbolicInetAddr const& rhs) const;
	
	bool operator>=(SymbolicInetAddr const& rhs) const;
private:
	std::string m_host;
	int m_port;
};


inline void swap(SymbolicInetAddr& o1, SymbolicInetAddr& o2)
{
	o1.swap(o2);
}

inline std::ostream& operator<<(std::ostream& strm, SymbolicInetAddr const& addr)
{
	addr.toStream(strm);
	return strm;
}

#endif
