/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef TEXTCONTENTVALIDATOR_H_
#define TEXTCONTENTVALIDATOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ResponseFilterBase.h"
#include "NonCopyable.h"
#include "SplittableBuffer.h"
#include <memory>

class HttpResponseMetadata;
class ResponseFilterChain;

class TextContentValidator : public ResponseFilterBase
{
	DECLARE_NON_COPYABLE(TextContentValidator)
public:
	TextContentValidator(ResponseFilterChain& filter_chain);
	
	virtual ~TextContentValidator();
	
	virtual void processMetadata(std::auto_ptr<HttpResponseMetadata> metadata);
	
	virtual void processBodyData(SplittableBuffer& data, bool eof);
private:
	bool isText() const;
	
	std::auto_ptr<HttpResponseMetadata> m_ptrMetadata;
	SplittableBuffer m_bufferedData;
	unsigned m_bytesChecked;
	unsigned m_numSpaces;
	unsigned m_numASCII;
};

#endif
