/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CombinedUrlPatterns.h"
#include "URI.h"
#include "BString.h"

bool
CombinedUrlPatterns::isFilteringDisabled(URI const& url) const
{
	BString const subj(url.toBString());
	if (m_localPatterns.isFilteringDisabled(subj)) {
		return true;
	} else if (m_standardPatterns.isFilteringDisabled(subj)) {
		return true;
	}
	return false;
}

UrlPatterns::Substitution
CombinedUrlPatterns::getSubstitutionFor(URI const& url) const
{
	BString const subj(url.toBString());
	UrlPatterns::Substitution subst = UrlPatterns::NO_SUBSTITUTION;
	UrlPatterns::Substitution const nosubst = UrlPatterns::NO_SUBSTITUTION;
	if (m_localPatterns.isExplicitlyAllowed(subj)) {
		// noting
	} else if ((subst = m_localPatterns.getSubstitutionFor(subj)) != nosubst) {
		// nothing
	} else if (m_standardPatterns.isExplicitlyAllowed(subj)) {
		// nothing
	} else if ((subst = m_standardPatterns.getSubstitutionFor(subj)) != nosubst) {
		// nothing
	}
	return subst;
}

int
CombinedUrlPatterns::getHintFor(URI const& url) const
{
	BString const subj(url.toBString());
	int hint = 0;
	if ((hint = m_localPatterns.getHintFor(subj)) != 0) {
		// nothing
	} else if ((hint = m_standardPatterns.getHintFor(subj)) != 0) {
		// nothing
	}
	return hint;
}
