/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FilterJsLogHandler.h"
#include "FilterJsLogger.h"
#include "FilterConfigWindow.h"
#include "Application.h"
#include "OperationLog.h"

using namespace std;

FilterJsLogHandler::FilterJsLogHandler(InterthreadCommandQueue& command_queue)
:	m_rCommandQueue(command_queue)
{
	FilterJsLogger::setHandler(this);
}

FilterJsLogHandler::~FilterJsLogHandler()
{
}

void
FilterJsLogHandler::logMessage(
	FilterTag const& filter_tag, FilterGroupTag const& group_tag,
	std::string const& msg)
{
	if (FilterConfigWindow::isFilterGroupBeingEdited(group_tag)) {
		OperationLog* log = OperationLog::instance();
		log->appendRecord(
			Application::localeToUtf8(msg), log->getDefaultStyle()
		);
	}
}

void
FilterJsLogHandler::logError(
	FilterTag const& filter_tag, FilterGroupTag const& group_tag,
	std::string const& msg, int lineno,
	std::string const& linebuf, int linepos)
{
	if (FilterConfigWindow::isFilterGroupBeingEdited(group_tag)) {
		OperationLog* log = OperationLog::instance();
		log->appendJsError(msg, lineno, linebuf, linepos);
	}
}

InterthreadCommandQueue&
FilterJsLogHandler::getCommandQueue()
{
	return m_rCommandQueue;
}
