/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef STYLEDTEXT_H_
#define STYLEDTEXT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "TextStyle.h"
#include "IntrusivePtr.h"
#include <ace/config-lite.h>
#include <wx/string.h>
#include <wx/textctrl.h>

class StyledText
{
public:
	// Member-wise copying is OK.

	StyledText(
		wxString const& text,
		IntrusivePtr<TextStyle const> const& style);

	wxString& text() { return m_text; }

	wxString const& text() const { return m_text; }

	wxTextAttr const& style() const { return *m_ptrStyle; }
private:
	wxString m_text;
	IntrusivePtr<TextStyle const> m_ptrStyle;
};


inline
StyledText::StyledText(
	wxString const& text, IntrusivePtr<TextStyle const> const& style)
:	m_text(text),
	m_ptrStyle(style)
{
}

#endif
