/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef WORKERTHREADPOOL_H_
#define WORKERTHREADPOOL_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "ConnAcceptor.h"
#include "RefCountableSAP.h"
#include "IntrusivePtr.h"
#include "IntrusiveList.h"
#include "TimeStamp.h"
#include <ace/config-lite.h>
#include <ace/SOCK_Stream.h>
#include <ace/Thread_Manager.h>
#include <ace/Synch.h>
#include <deque>
#include <utility>

class Reactor;
class ServiceContext;

class WorkerThreadPool
{
	DECLARE_NON_COPYABLE(WorkerThreadPool)
public:
	WorkerThreadPool();
	
	~WorkerThreadPool();
	
	void start();
	
	bool addAcceptor(ConnAcceptor::AcceptorPtr const& acceptor);
	
	void removeAcceptor(ConnAcceptor::AcceptorPtr const& acceptor);
	
	void removeAllAcceptors();
private:
	enum { WAIT_FOR_NEW_TASK = 10 }; // seconds
	enum { WAITERS_KEEP_ALIVE = 4 }; // not counting the Leader
	enum NewThreadStatus { READY, CLOSING, FAILURE };
	
	class ReactorRegistration;
	
	typedef IntrusivePtr<RefCountableSAP<ACE_SOCK_Stream> > SocketPtr;
	typedef IntrusiveList<ReactorRegistration> ReactorList;
	typedef ACE_Thread_Mutex Mutex;
	typedef ACE_Mutex LeaderMutex;
	
	NewThreadStatus prepareNewThread();
	
	int wait();
	
	void runService();
	
	bool tryBecomingLeader(ServiceContext& service_context);
	
	static ACE_THR_FUNC_RETURN runThread(void *arg);
	
	ACE_Thread_Manager m_threadManager;
	Mutex m_mutex;
	ACE_Condition<Mutex> m_cond;
	LeaderMutex m_leaderMutex;
	ConnAcceptor m_connAcceptor;
	ReactorList m_runningReactors;
	TimeStamp m_lastThreadCreateTime;
	int m_numWaiters; // running threads waiting for tasks
	bool m_isClosing;
};

/*
If we decide to make this class a singleton, we'll have
to make sure it gets destroyed before JsRuntimeSingleton.
*/

#endif
