# - Locate the ACE library
# This module defines
#  ACE_FOUND -- true if ACE was found
#  ACE_LIBRARY -- the library to link against
#  ACE_INCLUDE_DIR -- path to ace/ACE.h
MACRO(BF_FIND_ACE)
	GET_FILENAME_COMPONENT(parent_dir_ "${PROJECT_SOURCE_DIR}/.." ABSOLUTE)
	FIND_PATH(
		ACE_INCLUDE_DIR ace/ACE.h
		PATHS /usr/include /usr/local/include "${parent_dir_}/ACE_wrappers"
		DOC "Path to ace/ACE.h"
	)
	FIND_LIBRARY(
		ACE_LIBRARY ACE
		PATHS /usr/lib /usr/local/lib "${parent_dir_}/ACE_wrappers/ace"
		DOC "Path to ACE library file"
	)
	IF(ACE_INCLUDE_DIR AND ACE_LIBRARY)
		SET(ACE_FOUND TRUE)
	ELSE(ACE_INCLUDE_DIR AND ACE_LIBRARY)
		SET(ACE_FOUND FALSE)
	ENDIF(ACE_INCLUDE_DIR AND ACE_LIBRARY)
ENDMACRO(BF_FIND_ACE)
