# - Locate the wxWidgets library
# This module defines
#  WX_FOUND -- true if ACE was found
#  WX_LIB_DIR -- directory where wx libraries are located
#  AC_INCLUDE_DIR -- path to wx/wx.h
MACRO(BF_FIND_WX)
	GET_FILENAME_COMPONENT(parent_dir_ "${PROJECT_SOURCE_DIR}/.." ABSOLUTE)
	FIND_PATH(
		WX_INCLUDE_DIR wx/wx.h
		PATHS "${parent_dir_}/wxWidgets/include"
		DOC "Path to wx/wx.h"
	)
	FIND_PATH(
		WX_LIB_DIR wxbase28.lib
		PATHS "${parent_dir_}/wxWidgets/lib/vc_lib"
		DOC "Path to wxbase28.lib"
	)
	IF(WX_INCLUDE_DIR AND WX_LIB_DIR)
		SET(WX_FOUND TRUE)
	ELSE(WX_INCLUDE_DIR AND WX_LIB_DIR)
		SET(WX_FOUND FALSE)
	ENDIF(WX_INCLUDE_DIR AND WX_LIB_DIR)
ENDMACRO(BF_FIND_WX)
