/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "prcvar.h"
#include "private.h"
#include <cassert>

PRCondVar* PR_NewCondVar(PRLock* lock)
{
	PRCondVar* cvar = 0;
	ACE_NEW_RETURN(cvar, PRCondVar(lock), 0);
	return cvar;
}

void PR_DestroyCondVar(PRCondVar* cvar)
{
	delete cvar;
}

PRStatus PR_WaitCondVar(PRCondVar* cvar, PRIntervalTime timeout)
{
	// js engine only uses it with no timeout
	assert(timeout == PR_INTERVAL_NO_TIMEOUT);
	return static_cast<PRStatus>(cvar->cond.wait(cvar->cond.mutex()));
}

PRStatus PR_NotifyCondVar(PRCondVar* cvar)
{
	return static_cast<PRStatus>(cvar->cond.signal());
}

PRStatus PR_NotifyAllCondVar(PRCondVar* cvar)
{
	return static_cast<PRStatus>(cvar->cond.broadcast());
}
