/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CHAINASYNCCONNECTOR_H_
#define CHAINASYNCCONNECTOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "Observer.h"
#include "AsyncConnector.h"
#include "AsyncConnectorListener.h"
#include "SocksAsyncConnector.h"
#include "SocksConnectorListener.h"
#include "TimeDelta.h"
#include <vector>
#include <memory>

class ChainConnectorListener;
class ProxyDescriptor;
class ConnectionRoute;
class Reactor;

class ChainAsyncConnector :
	private AsyncConnectorListener,
	private SocksConnectorListener
{
	DECLARE_NON_COPYABLE(ChainAsyncConnector)
public:
	typedef ChainConnectorListener Listener;
	
	ChainAsyncConnector();
	
	~ChainAsyncConnector();
	
	bool isInProgress() const { return m_pReactor != 0; }
	
	/**
	 * \brief Initiate a connection through a proxy chain.
	 *
	 * The proxy chain can be empty.\n
	 * If another connection is in progress, it is aborted.
	 * \note HTTP proxies are not allowed in the chain, even as
	 *       a last component.  If they were allowed, \a target_addr
	 *       would have to be ignored.
	 */
	void initiate(Listener& listener, Reactor& reactor,
		ConnectionRoute const& route,
		TimeDelta const* hop_timeout = 0);
	
	/**
	 * \brief Abort the ongoing connection (if any).
	 */
	void abort();
private:
	class Hops;
	
	virtual void onConnectionEstablished(AutoClosingSAP<ACE_SOCK_Stream>& conn);
	
	virtual void onConnectionFailed(AsyncConnectorError const& err);
	
	virtual void onConnThroughSocksDone(AutoClosingSAP<ACE_SOCK_Stream>& conn);
	
	virtual void onConnThroughSocksFailed(SocksError const& err);
	
	void onHopDone(AutoClosingSAP<ACE_SOCK_Stream>& conn);
	
	static bool getSocksType(
		ProxyDescriptor const& proxy,
		SocksAsyncConnector::SocksType& type);
	
	SingleObserverLink<Listener> m_observerLink;
	AsyncConnector m_directConnector;
	SocksAsyncConnector m_socksConnector;
	TimeDelta m_hopTimeout;
	std::auto_ptr<Hops> m_ptrHops;
	Reactor* m_pReactor;
};

#endif
