/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef GZIPCOMPRESSOR_H_
#define GZIPCOMPRESSOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.h"
#include "AbstractCompressor.h"
#include "NonCopyable.h"
#include "DeflateCompressor.h"
#include "BString.h"
#include <stddef.h>
#include <limits>

class DataChunk;
class SplittableBuffer;

class GzipCompressor : public AbstractCompressor
{
	DECLARE_NON_COPYABLE(GzipCompressor)
public:
	GzipCompressor();
	
	virtual ~GzipCompressor();
	
	virtual void reset();
	
	virtual bool isError() const;
	
	virtual void consume(SplittableBuffer& data, bool eof);
	
	virtual size_t retrieveOutput(SplittableBuffer& buf,
		size_t limit = std::numeric_limits<size_t>::max());
private:
	enum State {
		ST_WRITING_HEADER, ST_COMPRESSING,
		ST_WRITING_FOOTER, ST_FINISHED, ST_ERROR
	};
	
	void updateInputCRC32(SplittableBuffer const& data);
	
	void prepareFooter();
	
	static char const m_sHeader[];
	State m_state;
	bool m_isEOF;
	size_t m_inputLength;
	uint32_t m_inputCRC32;
	size_t m_headerBytesWritten;
	size_t m_footerBytesWritten;
	BString m_footer;
	DeflateCompressor m_deflateCompressor;
};

#endif
