/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HtmlNodeWithChildren.h"

HtmlNodeWithChildren::HtmlNodeWithChildren()
{
}

HtmlNodeWithChildren::HtmlNodeWithChildren(HtmlNodeWithChildren const& other)
{
	HtmlNode const* child = other.getFirstChild();
	for (; child; child = child->getNextSibling()) {
		appendChild(child->clone().get());
	}
}

HtmlNodeWithChildren::~HtmlNodeWithChildren()
{
	HtmlNode* child;
	while ((child = m_sentinel.getNextSibling())) {
		child->detachFromParent();
	}
}

bool
HtmlNodeWithChildren::hasChildren() const
{
	return m_sentinel.getNextSibling();
}

HtmlNode*
HtmlNodeWithChildren::getFirstChild()
{
	return m_sentinel.getNextSibling();
}

HtmlNode const*
HtmlNodeWithChildren::getFirstChild() const
{
	return m_sentinel.getNextSibling();
}

HtmlNode*
HtmlNodeWithChildren::getLastChild()
{
	return m_sentinel.getPrevSibling();
}

HtmlNode const*
HtmlNodeWithChildren::getLastChild() const
{
	return m_sentinel.getPrevSibling();
}

void
HtmlNodeWithChildren::appendChild(HtmlNode* node)
{
	insertChildBefore(node, &m_sentinel);
}

void
HtmlNodeWithChildren::prependChild(HtmlNode* node)
{
	insertChildAfter(node, &m_sentinel);
}

void
HtmlNodeWithChildren::removeAllChildren()
{
	HtmlNode* child;
	while ((child = m_sentinel.getNextSibling())) {
		child->detachFromParent();
	}
}


/*================= HtmlNodeWithChildren::Sentinel =================== */

HtmlNodeWithChildren::Sentinel::~Sentinel()
{
}

HtmlNodePtr
HtmlNodeWithChildren::Sentinel::clone() const
{
	return HtmlNodePtr();
}

HtmlNode::NodeType
HtmlNodeWithChildren::Sentinel::getNodeType() const
{
	return FRAGMENT_NODE;
}
