/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef REQUESTTAG_H_
#define REQUESTTAG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Tag.h"
#include "Flags.h"
#include "DownloadProgress.h"
#include "RefCountable.h"
#include "RefCounter.h"

class ACE_MT_SYNCH;

struct RequestFlags
{
	enum FlagEnum {
		REQUEST_ANALYZE   = 1 << 0,
		RESPONSE_MODIFIED = 1 << 1,
		RESPONSE_CRAFTED  = 1 << 2
	};
};


class RequestIdRep : public RefCountable<RefCounter<ACE_MT_SYNCH> >
{
};


class RequestTagRep : public RequestIdRep, public RequestFlags
{
public:
	DownloadProgress& downloadProgress() { return m_downloadProgress; }
	
	DownloadProgress const& downloadProgress() const { return m_downloadProgress; }
	
	Flags<FlagEnum>& flags() { return m_flags; }
	
	Flags<FlagEnum> const& flags() const { return m_flags; }
private:
	DownloadProgress m_downloadProgress;
	Flags<FlagEnum> m_flags;
};


class RequestTag : public Tag<RequestTagRep>, public RequestFlags
{
};


class RequestId : public Tag<RequestIdRep>
{
public:
	RequestId() {}
	
	RequestId(RequestTag const& tag) : Tag<RequestIdRep>(tag) {}
};

#endif
