/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SubstitutionRequestParser.h"
#include "StringUtils.h"
#include "BString.h"
#include "URI.h"

bool
SubstitutionRequestParser::parse(URI const& uri, BString const& prefix)
{
	BString const& path = uri.getRawPath();
	char const* begin = path.begin();
	char const* const path_end = path.end();
	if (!StringUtils::startsWith(begin, path_end, prefix.begin(), prefix.end())) {
		return false;
	}
	begin += prefix.size();
	char const* end = path_end;
	unsigned int width = StringUtils::parseUnsigned<unsigned int>(begin, end);
	if (end == begin || end == path_end || *end != 'x') {
		return false;
	}
	begin = end;
	++begin;
	end = path_end;
	unsigned int height = StringUtils::parseUnsigned<unsigned int>(begin, end);
	if (end == begin) {
		return false;
	} else if (end != path_end) {
		if (*end == '/') {
			++end;
		} else {
			return false;
		}
	}
	handleResult(width, height, uri, BString(path, end, path_end)); 
	return true;
}
