/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef WORKERTHREADPOOLEXSINGLETON_H_
#define WORKERTHREADPOOLEXSINGLETON_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "WorkerThreadPoolEx.h"

/**
 * \brief Non thread-safe accessor to a WorkerThreadPoolEx instance.
 */
class WorkerThreadPoolExSingleton
{
	DECLARE_NON_COPYABLE(WorkerThreadPoolExSingleton)
public:
	/**
	 * \brief Access a global instance of WorkerThreadPool.
	 * \note This method is not thread-safe.  Because WorkerThreadPoolEx
	 *       is not thread-safe itself, so there was no point making
	 *       its accessor thread-safe.
	 */
	static WorkerThreadPoolEx* instance();
};

#endif
