/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "DebugAgent.h"
#include "Debug.h"
#include "DebugWindow.h"
#include "Application.h"
#include "OperationLog.h"
#include <ace/config-lite.h>
#include <ace/OS_NS_Thread.h>
#include <string>
#include <iostream>

using namespace std;

namespace GtkGUI
{

DebugAgent::DebugAgent(InterthreadCommandQueue& command_queue)
:	m_rCommandQueue(command_queue)
{
	Debug::setAgent(this);	
}

DebugAgent::~DebugAgent()
{
}

InterthreadCommandQueue&
DebugAgent::getCommandQueue()
{
	return m_rCommandQueue;
}

void
DebugAgent::clientConnectionBegin(ACE_thread_t thread_id)
{
	DebugWindow* wnd = Application::instance()->debugWindow();
	if (wnd) {
		wnd->clientConnectionBegin(thread_id);
	}
}

void
DebugAgent::clientConnectionEnd(ACE_thread_t thread_id)
{
	DebugWindow* wnd = Application::instance()->debugWindow();
	if (wnd) {
		wnd->clientConnectionEnd(thread_id);
	}
}

void
DebugAgent::registerClientRequest(ACE_thread_t thread_id,
	int request_id, std::string request_url)
{
	DebugWindow* wnd = Application::instance()->debugWindow();
	if (wnd) {
		wnd->registerClientRequest(thread_id, request_id, request_url);
	}
}

void
DebugAgent::httpMessageBegin(
	ACE_thread_t thread_id, int request_id,
	HttpMessageType type, std::string const& headers)
{
	DebugWindow* wnd = Application::instance()->debugWindow();
	if (wnd) {
		wnd->httpMessageBegin(thread_id, request_id, type, headers);
	}
}

void
DebugAgent::httpMessageEnd(ACE_thread_t thread_id,
	HttpMessageType type, bool error)
{
	DebugWindow* wnd = Application::instance()->debugWindow();
	if (wnd) {
		wnd->httpMessageEnd(thread_id, type, error);
	}
}

void
DebugAgent::logMessage(ACE_thread_t thread_id, std::string const& msg)
{
	if (thread_id == ACE_OS::thr_self()) {
		std::cerr << msg << std::endl;
		return;
	}
	
	DebugWindow* wnd = Application::instance()->debugWindow();
	if (wnd) {
		wnd->logMessage(thread_id, msg);
	}
}

void
DebugAgent::logTraffic(
	ACE_thread_t thread_id,
	SplittableBuffer& traf, TrafficDirection dir)
{
	DebugWindow* wnd = Application::instance()->debugWindow();
	if (wnd) {
		wnd->logTraffic(thread_id, traf, dir);
	}
}

} // namespace GtkGUI
