/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef REQUESTLOGHANDLER_H_
#define REQUESTLOGHANDLER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "AbstractRequestLogHandler.h"
#include <glibmm/refptr.h>

class RequestId;
class InterthreadCommandQueue;

namespace Gtk {
	class TreeView;
	class TreePath;
}
namespace Gdk {
	class Color;
}


namespace GtkGUI
{

class RequestLogHandler : public AbstractRequestLogHandler
{
	DECLARE_NON_COPYABLE(RequestLogHandler)
public:
	RequestLogHandler(InterthreadCommandQueue& command_queue);
	
	virtual ~RequestLogHandler();
	
	void attachView(Gtk::TreeView* view);
	
	void clearLog();
	
	void copyToClipboard();
	
	void copyUrlAtRow(Gtk::TreePath const& path);
	
	static Gdk::Color getColorFor(RequestType type);
	
	virtual InterthreadCommandQueue& getCommandQueue();
	
	virtual void processRequest(
		RequestId const& req_id, std::string const& uri, RequestType type);
	
	virtual void processResponseBegin(
		RequestId const& id, int status_code,
		DownloadProgress const& progress);
	
	virtual void processResponseEnd(
		RequestId const& req_id, int req_flags,
		DownloadProgress const& progress, bool error);
	
	virtual void processRequestCancel(
		RequestId const& req_id, DownloadProgress const& progress);
private:
	class ListModel;
	
	InterthreadCommandQueue& m_rCommandQueue;
	Glib::RefPtr<ListModel> m_ptrModel;
};

} // namespace GtkGUI

#endif
