/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IPv4SubnetParserTestSuite.h"
#include "HtmlLexerTestSuite.h"
#include "XmlLexerTestSuite.h"
#include "ForwardingTestSuite.h"
#include "FilterOrderingTestSuite.h"
#include "HeuristicScoreTestSuite.h"
#include <boost/test/unit_test.hpp>
#include <memory>

using boost::unit_test_framework::test_suite;

test_suite* init_unit_test_suite(int, char*[])
{
	test_suite* top_ts = BOOST_TEST_SUITE("Master test suite");
	
	top_ts->add(new IPv4SubnetParserTestSuite);
	top_ts->add(new HtmlLexerTestSuite);
	top_ts->add(new XmlLexerTestSuite);
	top_ts->add(new ForwardingTestSuite);
	top_ts->add(new FilterOrderingTestSuite);
	top_ts->add(new HeuristicScoreTestSuite);
	
	return top_ts;
}
