/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
Reasons for a custom implementation instead of using ACE_Atomic_Op:

1. libjs depends on NSPR. Since I don't want that dependency and
also don't like the idea of mixing NSPR with ACE (both are very intrusive),
I just implement a subset of NSPR that's required by libjs.
NSPR's atomic operations look like this: PR_AtomicDecrement(PRInt32* val).
That kind of interface can't be implemented in terms of ACE_Atomic_Op.
2. ACE_Atomic_Op currently has an optimized implementation just for X86.
3. ACE_Atomic_Op generic (not optimized) implementation is less than perfect.
It creates a separate mutex for each atomic value. My implementation
uses several global mutexes and selects the right one by hashing
the variable's address.
*/

#ifndef ATOMICOPS_H_
#define ATOMICOPS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.h"

namespace AtomicOps {

// Writes newval to *mem and returns the old *mem value.
int32_t set(int32_t volatile* mem, int32_t newval);

// Adds delta to *mem and returns the new *mem value.
int32_t add(int32_t volatile* mem, int32_t delta);

} // namespace AtomicOps

#endif
