/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpParserBase.h"
#include "HttpState.h"
#include "SplittableBuffer.h"

using namespace std;

HttpParserBase::HttpParserBase()
:	m_stateSizedFlatBody(*this),
	m_stateUnsizedFlatBody(*this),
	m_stateChunkHeader(*this),
	m_stateChunkBody(*this),
	m_stateFooters(*this),
	m_pCurState(&m_stateInactive)
{
}

HttpParserBase::~HttpParserBase()
{
}

void
HttpParserBase::switchToInactive()
{
	if (m_pCurState != &m_stateInactive) {
		m_pCurState->cleanup();
		m_pCurState = activateStateInactive();
	}
}

void
HttpParserBase::switchToUnsizedFlatBody()
{
	if (m_pCurState != &m_stateUnsizedFlatBody) {
		m_pCurState->cleanup();
		m_pCurState = activateStateUnsizedFlatBody();
	}
}

HttpParserBase::Status
HttpParserBase::processNewData(
	SplittableBuffer& input, bool eof,
	SplittableBuffer& body, bool& body_eof)
{
	bool const was_inactive = isInactiveState();
	while (true) {
		HttpState* next_state = m_pCurState->processNewData(
			input, eof, body, body_eof
		);
		if (next_state != m_pCurState) {
			m_pCurState->cleanup();
			m_pCurState = next_state;
		} else {
			break;
		}
	}
	
	if (isErrorState()) {
		return ERROR_STATE;
	} else if (isInactiveState() && !was_inactive) {
		return MESSAGE_ENDS;
	} else if (input.empty()) {
		return DATA_PROCESSED;
	} else {
		return NEED_MORE_DATA;
	}
}
