/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef IMAGERESPONSEFILTER_H_
#define IMAGERESPONSEFILTER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ResponseFilterBase.h"
#include "ResponseFilterChain.h"
#include "NonCopyable.h"
#include <memory>

class AbstractImageInspector;
class HttpResponseMetadata;
class ErrorDescriptor;
class RequestStatus;

class ImageResponseFilter : public ResponseFilterBase
{
	DECLARE_NON_COPYABLE(ImageResponseFilter)
public:
	ImageResponseFilter(ResponseFilterChain& filter_chain,
		bool ignore_size, std::auto_ptr<AbstractImageInspector> inspector);
	
	virtual ~ImageResponseFilter();
	
	virtual void processMetadata(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata);
	
	virtual void processBodyData(
		RequestStatus& status, SplittableBuffer& data, bool eof);
private:
	enum State { INSPECTING, FORWARDING, SUBSTITUTING };
	
	bool isAd();
	
	void outputAdSubstitution(RequestStatus& status);
	
	void considerRequestCancel(RequestStatus& status);
	
	State m_state;
	bool m_ignoreSize;
	std::auto_ptr<AbstractImageInspector> m_ptrInspector;
	std::auto_ptr<HttpResponseMetadata> m_ptrMetadata;
};

#endif
