/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ResponseFilterBase.h"
#include "ImmediateResponse.h"
#include "AbstractResponseHandler.h"
#include "RequestStatus.h"

class ResponseFilterBase::ImmediateResponseHandler :
	public AbstractResponseHandler
{
public:
	ImmediateResponseHandler(ResponseFilterBase& filter);
	
	virtual void processProvisionalResponse(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata);
	
	virtual void processResponseMetadata(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata);
	
	virtual void processBodyData(
		RequestStatus& status, SplittableBuffer& data, bool eof);
	
	virtual void processError(
		RequestStatus& status, std::auto_ptr<ErrorDescriptor> edesc);
private:
	ResponseFilterBase& m_rFilter;
};


ResponseFilterBase::ResponseFilterBase(ResponseFilterChain& chain)
:	m_rChain(chain)
{
}

ResponseFilterBase::~ResponseFilterBase()
{
}

void
ResponseFilterBase::outputMetadata(
	RequestStatus& status,
	std::auto_ptr<HttpResponseMetadata> metadata)
{
	m_ptrNextFilter = m_rChain.nextFilter(*metadata);
	m_ptrNextFilter->processMetadata(status, metadata);
}

void
ResponseFilterBase::outputBodyData(
	RequestStatus& status, SplittableBuffer& data, bool eof)
{
	m_ptrNextFilter->processBodyData(status, data, eof);
}

void
ResponseFilterBase::outputResponse(
	RequestStatus& status, ImmediateResponse& response)
{
	ImmediateResponseHandler handler(*this);
	response.output(
		handler, getFilterChain().getRequestPtr(),
		status, getRequestTag()
	);
}

/*============== ResponseFilterBase::ImmediateResponseHandler ============*/

ResponseFilterBase::ImmediateResponseHandler::ImmediateResponseHandler(
	ResponseFilterBase& filter)
:	m_rFilter(filter)
{
}

void
ResponseFilterBase::ImmediateResponseHandler::processProvisionalResponse(
	RequestStatus& status,
	std::auto_ptr<HttpResponseMetadata> metadata)
{
	m_rFilter.getFinalRecipient().processProvisionalResponse(status, metadata);
}

void
ResponseFilterBase::ImmediateResponseHandler::processResponseMetadata(
	RequestStatus& status,
	std::auto_ptr<HttpResponseMetadata> metadata)
{
	m_rFilter.outputMetadata(status, metadata);
}

void
ResponseFilterBase::ImmediateResponseHandler::processBodyData(
	RequestStatus& status,
	SplittableBuffer& data, bool eof)
{
	m_rFilter.outputBodyData(status, data, eof);
}

void
ResponseFilterBase::ImmediateResponseHandler::processError(
	RequestStatus& status, std::auto_ptr<ErrorDescriptor> edesc)
{
	status.cancel(edesc);
}
