/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPCACHE_RESPONSERESOLUTION_H_
#define HTTPCACHE_RESPONSERESOLUTION_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractResponseReader.h"
#include "AbstractResponseWriter.h"
#include <memory>

namespace HttpCache
{

class ResponseResolution
{
private:
	struct CopyHelper
	{
		AbstractResponseReader* reader;
		AbstractResponseWriter* writer;
		
		CopyHelper(ResponseResolution& r)
		: reader(r.reader.release()),
		writer(r.writer.release()) {}
	};
public:
	std::auto_ptr<AbstractResponseReader> reader;
	std::auto_ptr<AbstractResponseWriter> writer;
	
	ResponseResolution() {}
	
	ResponseResolution(CopyHelper helper)
	: reader(helper.reader), writer(helper.writer) {}
	
	ResponseResolution(std::auto_ptr<AbstractResponseReader> r) : reader(r) {}
	
	ResponseResolution(std::auto_ptr<AbstractResponseWriter> w) : writer(w) {}
	
	operator CopyHelper() { return CopyHelper(*this); }
	
	ResponseResolution& operator=(CopyHelper helper) {
		reader.reset(helper.reader);
		writer.reset(helper.writer);
		return *this;
	}
};

} // namespace HttpCache

#endif
