/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "MvcListModel.h"
#include "MvcListView.h"
#include <cassert>

MvcListModel::MvcListModel()
{
}

MvcListModel::~MvcListModel()
{
}

void
MvcListModel::attachView(MvcListView& view)
{
	m_views.push_back(view);
}

void
MvcListModel::informRowsInserted(long idx_begin, long idx_end)
{
	if (idx_begin == idx_end) {
		return;
	}
	assert(idx_end > idx_begin);

	Views::iterator it(m_views.begin());
	Views::iterator const end(m_views.end());
	for (; it != end; ++it) {
		invalidateRows(*it, idx_begin);
	}
}

void
MvcListModel::informRowsDeleted(long idx_begin, long idx_end)
{
	if (idx_begin == idx_end) {
		return;
	}
	assert(idx_end > idx_begin);

	Views::iterator it(m_views.begin());
	Views::iterator const end(m_views.end());
	for (; it != end; ++it) {
		invalidateRows(*it, idx_begin);
	}
}

void
MvcListModel::informRowsModified(long idx_begin, long idx_end)
{
	if (idx_begin == idx_end) {
		return;
	}
	assert(idx_end > idx_begin);
	
	Views::iterator it(m_views.begin());
	Views::iterator const end(m_views.end());
	for (; it != end; ++it) {
		invalidateRows(*it, idx_begin, idx_end);
	}
}

void
MvcListModel::invalidateRows(MvcListView& view, long idx_begin, long idx_end)
{
	if (idx_begin < idx_end) {
		view.RefreshItems(idx_begin, idx_end - 1);
	}
}

void
MvcListModel::invalidateRows(MvcListView& view, long idx_begin)
{
	long num_rows = getRowCount();
	view.onRowCountChanging();
	view.SetItemCount(num_rows);
	invalidateRows(view, idx_begin, num_rows);
	view.onRowCountChanged();
}
