/*
    BFilter - a web proxy which removes banner ads
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTMLDETECTOR_H_
#define HTMLDETECTOR_H_

#include "HtmlDetectorCore.h"
#include "NonCopyable.h"

class HtmlDetector : private HtmlDetectorCore
{
	friend struct HtmlDetectorCore::Actions;
	DECLARE_NON_COPYABLE(HtmlDetector)
public:
	enum Status { IN_PROGRESS, HTML_DETECTED, HTML_NOT_DETECTED, EMPTY_DOC };
	
	HtmlDetector();
	
	~HtmlDetector();
	
	using HtmlDetectorCore::consume;
	
	using HtmlDetectorCore::bufferedData;
	
	using HtmlDetectorCore::reset;
	
	Status getStatus() const { return m_status; }
private:
	void onHtmlDetected() { m_status = HTML_DETECTED; }
	
	void onHtmlNotDetected() { m_status = HTML_NOT_DETECTED; }
	
	void onEmptyDoc() { m_status = EMPTY_DOC; }
	
	Status m_status;
};

#endif
