/* This program convert `\' in big5 wide-character to `\\'. */
/* by platin */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <locale.h>
#include <libintl.h>

#define _(STRING) gettext(STRING)

#define PACKAGE "bg5cc"     
#define LOCALEDIR "/usr/share/locale/"

const char *program_name; 

const char BIG5_MAX=0xf7;
const char BIG5_MIN=0xa0;

/* Display usage information and exit.  */
static void usage ()
{
    printf (_("Usage: %s INPUTFILE [OUTPUTFILE] \n\
This program convert `\\' in big5 wide-character to `\\\\'\n\n\
If input file is -, standard input is read. \n\
If output file is empty or -, output is written to standard output.\n"),
	    program_name);
}                     

void main(int argc, char *argv[])
{

  FILE *input_file,*output_file;
  char buffer[1];

  /* Set program name for messages.  */
  program_name = argv[0]; 

  setlocale(LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  textdomain(PACKAGE); 

  /* Check the argvs */
  if(argc <2 || argc > 3){
    usage();
    exit(-1);
  }

  if(! strcmp(argv[1],"-")){
    input_file=stdin;
  } else {
    input_file=fopen(argv[1], "r");
    if(input_file == NULL){
      fprintf(stderr, _("error while opening \"%s\" for reading: %s \n"),
	      argv[1],strerror(errno));
      exit(errno);
    }
  }

  if(argc == 2 || !strcmp(argv[2],"-")){
    output_file=stdout;
  } else {
    output_file=fopen(argv[2], "w");
    if(output_file == NULL){
      fprintf(stderr, _("error while opening \"%s\" for writing: %s \n"),
	      argv[2],strerror(errno));
      exit(errno);
    }
  }

  while(fread(buffer, 1, 1, input_file) && ! feof(input_file)){
    fwrite(buffer, 1, 1, output_file);
    if(*buffer >= BIG5_MIN && *buffer <= BIG5_MAX){
      if(fread(buffer,1,1,input_file) && !feof(input_file)){
	if(*buffer == '\\')
	  fwrite(buffer, 1, 1, output_file);
	fwrite(buffer, 1, 1, output_file);
      }
    }
  }

  fclose(output_file);
  fclose(input_file);

}
