/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_BOOK_H
#define INCLUDED_BOOK_H


#include "libraries.h"
#include "usfm.h"


class Book
{
public:
  Book (const ustring & path, bool check_unicode, ustring encoding);
  ~Book ();
  vector <ustring> cleaned_lines;
  void get_chapter (unsigned int chapternumber, vector <ustring>& lines);
  void set_chapter (vector <ustring> &lines);
  bool save ();
  vector <ustring> get_backups ();
  ustring get_backup_directory ();
  unsigned int get_previously_presented_chapter ();
  unsigned int get_id_index ();
  ustring from_encoding;
private:
  ustring mypath;
  unsigned int previously_presented_chapter;
  void get_chapter_boundaries (unsigned int chapter_number, unsigned int &begin, unsigned int &end);
  ustring backup_directory;
  void load_execute (bool gui, const ustring & path);
};


#endif
