/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_BOOKMETRICS_H
#define INCLUDED_BOOKMETRICS_H


#include "libraries.h"
#include "usfm.h"
#include "types.h"
#include <map>


class BookMetrics
{
public:
  BookMetrics (const ustring & path);
  virtual ~BookMetrics ();
  vector<unsigned int> get_chapters();
  vector<ustring> get_verses (unsigned int chapter);
private:
  map <unsigned int, VectorUstring> metrics;
  void create_metrics (const ustring& bookfilename, const ustring& metricsfilename);
  void parse_metrics (const ustring& filename);
  static void start_element_handler  (GMarkupParseContext *context,
                                      const gchar         *element_name,
                                      const gchar        **attribute_names,
                                      const gchar        **attribute_values,
                                      gpointer             user_data,
                                      GError             **error);
  virtual void start_element_handler (const gchar         *element_name,
                                      const gchar        **attribute_values);
  static void end_element_handler    (GMarkupParseContext *context,
                                      const gchar         *element_name,
                                      gpointer             user_data,
                                      GError             **error);
  virtual void end_element_handler   (const gchar         *element_name);
  static void error_handler          (GMarkupParseContext *context,
                                      GError              *error,
                                      gpointer             user_data);
  unsigned int parse_modified;
  unsigned int parse_chapter;
  VectorUstring parse_verses;
};


#endif
