/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "completion.h"


vector<ustring> * completion_get_table (CompletionType completiontype, Session * session)
{
  switch (completiontype) {
    case cpSearch :
      return &session->completion_search;
    case cpReplace :
      return &session->completion_replace;
    case cpGoto :
      return &session->completion_goto;
  }
  return &session->completion_search;
}


void completion_setup (GtkWidget * entry, CompletionType completiontype, Session * session)
// Sets up completion on an entry.
{
  // Create completion.
  GtkEntryCompletion * completion;
  completion = gtk_entry_completion_new ();
  // Assign it to the entry.
  gtk_entry_set_completion (GTK_ENTRY (entry), completion);
  // Free memory.
  g_object_unref (completion);
  // Create a model / store and fill it with data.
  GtkListStore * store;
  store = gtk_list_store_new (1, G_TYPE_STRING);
  GtkTreeIter iter;
  vector<ustring> * completiontable;
  completiontable = completion_get_table (completiontype, session);
  for (unsigned int i = 0; i < completiontable->size(); i++) {
    gtk_list_store_append (store, &iter);
    gtk_list_store_set (store, &iter, 0, completiontable->at(i).c_str(), -1);
  }
  gtk_entry_completion_set_model (completion, GTK_TREE_MODEL (store));
  // Free memory.
  g_object_unref (store);
  // Point it to first column to use.
  gtk_entry_completion_set_text_column (completion, 0);
}


void completion_finish (GtkWidget * entry, CompletionType completiontype, Session * session)
// Finalizes completion on an entry.
{
  // Get the word to add to the completion table.
  ustring word = gtk_entry_get_text (GTK_ENTRY (entry));
  // No word? Finish here.
  if (word.length() == 0)
    return;
  // Word already in table? Finish now.
  vector<ustring> * completiontable;
  completiontable = completion_get_table (completiontype, session);
  for (unsigned int i = 0; i < completiontable->size(); i++)
    if (completiontable->at(i) == word)
      return;
  // Add word to table.
  completiontable->push_back (word);
}
