/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_DIALOGREPLACE_H
#define INCLUDED_DIALOGREPLACE_H


#include <gtk/gtk.h>
#include "configuration.h"
#include "indexer.h"
#include "session.h"


class ReplaceDialog
{
public:
  ReplaceDialog (Configuration* configuration, Session * session, Indexer * worddatabase);
  virtual ~ ReplaceDialog ();
  virtual int run ();
  vector <ustring> results;
  bool is_indexing;
protected:
private:
  GtkWidget *replacedialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *table1;
  GtkWidget *label7;
  GtkWidget *label8;
  GtkWidget *entry2;
  GtkWidget *entry3;
  GtkWidget *checkbutton1;
  GtkWidget *selectbutton;
  GtkWidget *alignment1;
  GtkWidget *hbox1;
  GtkWidget *image1;
  GtkWidget *label9;
  GtkWidget *dialog_action_area1;
  GtkWidget *buttonfind;
  GtkWidget *buttoncancel;
  Configuration * myconfiguration;
  Session * mysession;
  Indexer * myworddatabase;
  vector <ustring> selectable_books;
  static void replacedialog_on_buttonfind_clicked (GtkButton *button, gpointer user_data);
  void on_buttonfind_clicked ();
  static void on_selectbutton_clicked (GtkButton *button, gpointer user_data);
  void on_selectbutton_clicked2 ();
  static void on_word_entry_changed (GtkEditable * editable, gpointer user_data);
  void set_gui ();  
};


#endif
