/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "utilities.h"
#include "dialogshownotes.h"
#include <glib.h>
#include "notes_utils.h"
#include "dialogdate.h"
#include "date_time_utils.h"
#include "combobox.h"


ShowNotesDialog::ShowNotesDialog (Configuration * configuration)
{
  // Save variabeles.
  myconfiguration = configuration;

  shownotesdialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (shownotesdialog), "Show Project Notes");
  gtk_window_set_position (GTK_WINDOW (shownotesdialog), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_modal (GTK_WINDOW (shownotesdialog), TRUE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (shownotesdialog), TRUE);
  gtk_window_set_type_hint (GTK_WINDOW (shownotesdialog), GDK_WINDOW_TYPE_HINT_DIALOG);
  // Hints for skipping the pager and the taskbar only cause trouble on some 
  // distributions, like what we had on Suse 9.2, when these hints were set, 
  // the whole dialog went under the main window, and so became invisible.
  // The gtk_window_set_transient_for function gives no benefits to a modal dialog.
  // This was tested, but no difference could be seen in any behaviour.

  dialog_vbox1 = GTK_DIALOG (shownotesdialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  table1 = gtk_table_new (8, 2, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, TRUE, TRUE, 0);
  
  GSList *radiobuttoncurrentverse_group = NULL;

  radiobuttoncurrentverse = gtk_radio_button_new_with_mnemonic (NULL, "Show notes for current _verse");
  gtk_widget_show (radiobuttoncurrentverse);
  gtk_table_attach (GTK_TABLE (table1), radiobuttoncurrentverse, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobuttoncurrentverse), radiobuttoncurrentverse_group);
  radiobuttoncurrentverse_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobuttoncurrentverse));

  radiobuttontoday = gtk_radio_button_new_with_mnemonic (NULL, "Show today's _notes");
  gtk_widget_show (radiobuttontoday);
  gtk_table_attach (GTK_TABLE (table1), radiobuttontoday, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobuttontoday), radiobuttoncurrentverse_group);
  radiobuttoncurrentverse_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobuttontoday));

  radiobuttonall = gtk_radio_button_new_with_mnemonic (NULL, "Show _all notes");
  gtk_widget_show (radiobuttonall);
  gtk_table_attach (GTK_TABLE (table1), radiobuttonall, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobuttonall), radiobuttoncurrentverse_group);
  radiobuttoncurrentverse_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobuttonall));

  radiobuttoncategory = gtk_radio_button_new_with_mnemonic (NULL, "Show notes of cate_gory");
  gtk_widget_show (radiobuttoncategory);
  gtk_table_attach (GTK_TABLE (table1), radiobuttoncategory, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobuttoncategory), radiobuttoncurrentverse_group);
  radiobuttoncurrentverse_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobuttoncategory));

  combobox1 = gtk_combo_box_new_text ();
  gtk_widget_show (combobox1);
  gtk_table_attach (GTK_TABLE (table1), combobox1, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  // Load availble categories and set text in entry.
  ReadText rt (notes_categories_filename());
  combobox_set_strings (combobox1, rt.lines);
  combobox_set_string (combobox1, configuration->show_notes_category);

  radiobuttondate = gtk_radio_button_new_with_mnemonic (NULL, "Show notes edited within a _date range");
  gtk_widget_show (radiobuttondate);
  gtk_table_attach (GTK_TABLE (table1), radiobuttondate, 0, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobuttondate), radiobuttoncurrentverse_group);
  radiobuttoncurrentverse_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobuttondate));

  hbox2 = gtk_hbox_new (FALSE, 5);
  gtk_widget_show (hbox2);
  gtk_table_attach (GTK_TABLE (table1), hbox2, 0, 2, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  fromdatebutton = gtk_button_new ();
  gtk_widget_show (fromdatebutton);
  gtk_box_pack_start (GTK_BOX (hbox2), fromdatebutton, FALSE, FALSE, 0);
  gtk_widget_set_size_request (fromdatebutton, 70, -1);

  alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (fromdatebutton), alignment1);

  hbox4 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox4);
  gtk_container_add (GTK_CONTAINER (alignment1), hbox4);

  image1 = gtk_image_new_from_stock ("gtk-goto-first", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image1);
  gtk_box_pack_start (GTK_BOX (hbox4), image1, FALSE, FALSE, 0);

  label1 = gtk_label_new_with_mnemonic ("_From");
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox4), label1, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label1, 30, -1);

  labeldatefrom = gtk_label_new ("");
  gtk_widget_show (labeldatefrom);
  gtk_box_pack_start (GTK_BOX (hbox2), labeldatefrom, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (labeldatefrom), 0, 0.5);

  hbox3 = gtk_hbox_new (FALSE, 5);
  gtk_widget_show (hbox3);
  gtk_table_attach (GTK_TABLE (table1), hbox3, 0, 2, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  todatebutton = gtk_button_new ();
  gtk_widget_show (todatebutton);
  gtk_box_pack_start (GTK_BOX (hbox3), todatebutton, FALSE, FALSE, 0);
  gtk_widget_set_size_request (todatebutton, 70, -1);

  alignment2 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment2);
  gtk_container_add (GTK_CONTAINER (todatebutton), alignment2);

  hbox5 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox5);
  gtk_container_add (GTK_CONTAINER (alignment2), hbox5);

  image2 = gtk_image_new_from_stock ("gtk-goto-last", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image2);
  gtk_box_pack_start (GTK_BOX (hbox5), image2, FALSE, FALSE, 0);

  label2 = gtk_label_new_with_mnemonic ("_To");
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox5), label2, FALSE, FALSE, 0);

  labeltodate = gtk_label_new ("");
  gtk_widget_show (labeltodate);
  gtk_box_pack_start (GTK_BOX (hbox3), labeltodate, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (labeltodate), 0, 0.5);

  checkbuttoncurrentproject = gtk_check_button_new_with_mnemonic ("Show notes of current _project only");
  gtk_widget_show (checkbuttoncurrentproject);
  gtk_table_attach (GTK_TABLE (table1), checkbuttoncurrentproject, 0, 2, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbuttoncurrentproject), configuration->show_notes_for_current_project_only);

  checkbutton_showproject = gtk_check_button_new_with_mnemonic ("Show p_roject");
  gtk_widget_show (checkbutton_showproject);
  gtk_table_attach (GTK_TABLE (table1), checkbutton_showproject, 0, 2, 8, 9,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_showproject), configuration->notes_show_project);
                    
  dialog_action_area1 = GTK_DIALOG (shownotesdialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (shownotesdialog), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (shownotesdialog), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) radiobuttoncurrentverse, "toggled",
                    G_CALLBACK (on_radiobutton_toggled),
                    gpointer(this));
  g_signal_connect ((gpointer) radiobuttontoday, "toggled",
                    G_CALLBACK (on_radiobutton_toggled),
                    gpointer(this));
  g_signal_connect ((gpointer) radiobuttonall, "toggled",
                    G_CALLBACK (on_radiobutton_toggled),
                    gpointer(this));
  g_signal_connect ((gpointer) radiobuttoncategory, "toggled",
                    G_CALLBACK (on_radiobutton_toggled),
                    gpointer(this));
  g_signal_connect ((gpointer) radiobuttondate, "toggled",
                    G_CALLBACK (on_radiobutton_toggled),
                    gpointer(this));
  g_signal_connect ((gpointer) fromdatebutton, "clicked",
                    G_CALLBACK (on_fromdatebutton_clicked),
                    gpointer(this));
  g_signal_connect ((gpointer) todatebutton, "clicked",
                    G_CALLBACK (on_todatebutton_clicked),
                    gpointer(this));
  g_signal_connect ((gpointer) okbutton1, "clicked",
                    G_CALLBACK (on_okbutton1_clicked),
                    gpointer(this));

  gtk_widget_grab_default (okbutton1);

  from_day = configuration->show_notes_date_range_from;
  to_day = configuration->show_notes_date_range_to;

  switch (configuration->show_notes_selector) {
    case snsCurrentVerse :
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobuttoncurrentverse), true);
      break;
    }
    case snsToday :
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobuttontoday), true);
      break;
    }
    case snsAll :
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobuttonall), true);
      break;
    }
    case snsCategory :
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobuttoncategory), true);
      break;
    }
    case snsDateRange :
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobuttondate), true);
      break;
    }
  }

  set_gui();
}


ShowNotesDialog::~ShowNotesDialog ()
{
  gtk_widget_destroy (shownotesdialog);
}


int ShowNotesDialog::run()
{
  return gtk_dialog_run (GTK_DIALOG (shownotesdialog));
}


void ShowNotesDialog::on_radiobutton_toggled (GtkToggleButton *togglebutton, gpointer user_data)
{
  ((ShowNotesDialog *) user_data)->set_gui();
}


void ShowNotesDialog::on_fromdatebutton_clicked (GtkButton *button, gpointer user_data)
{
  ((ShowNotesDialog *) user_data)->on_from_date();
}


void ShowNotesDialog::on_todatebutton_clicked (GtkButton *button, gpointer user_data)
{
  ((ShowNotesDialog *) user_data)->on_to_date();
}


void ShowNotesDialog::on_okbutton1_clicked (GtkButton *button, gpointer user_data)
{
  ((ShowNotesDialog *) user_data)->on_ok();
}


void ShowNotesDialog::on_from_date ()
{
  DateDialog dialog (&from_day);
  dialog.run ();
  set_gui();
}


void ShowNotesDialog::on_to_date ()
{
  DateDialog dialog (&to_day);
  dialog.run ();
  set_gui();
}


void ShowNotesDialog::on_ok ()
{
  myconfiguration->show_notes_selector = get_state();
  myconfiguration->show_notes_category = combobox_get_active_string (combobox1);
  myconfiguration->show_notes_date_range_from = from_day;
  myconfiguration->show_notes_date_range_to = to_day;
  myconfiguration->show_notes_for_current_project_only = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbuttoncurrentproject));
  myconfiguration->notes_show_project = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton_showproject));
}


void ShowNotesDialog::set_gui()
{
  gtk_widget_set_sensitive (combobox1, false);
  gtk_widget_set_sensitive (fromdatebutton, false);
  gtk_widget_set_sensitive (labeldatefrom, false);
  gtk_widget_set_sensitive (todatebutton, false);
  gtk_widget_set_sensitive (labeltodate, false);
  ShowNotesSelector selector = get_state ();
  switch (selector) {
    case snsCurrentVerse :
    case snsToday :
    case snsAll :
    {
      break;
    }
    case snsCategory :
    {
      gtk_widget_set_sensitive (combobox1, true);
      break;
    }
    case snsDateRange :
    {
      gtk_widget_set_sensitive (fromdatebutton, true);
      gtk_widget_set_sensitive (labeldatefrom, true);
      gtk_widget_set_sensitive (todatebutton, true);
      gtk_widget_set_sensitive (labeltodate, true);
      break;
    }
  }
  gtk_label_set_text (GTK_LABEL (labeldatefrom), date_time_julian_human_readable (from_day, true).c_str());
  gtk_label_set_text (GTK_LABEL (labeltodate), date_time_julian_human_readable (to_day, true).c_str());
}


ShowNotesSelector ShowNotesDialog::get_state ()
{
  ShowNotesSelector selector = snsCurrentVerse;
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobuttoncurrentverse)))
    selector = snsCurrentVerse;
  else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobuttontoday)))
    selector = snsToday;
  else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobuttonall)))
    selector = snsAll;
  else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobuttoncategory)))
    selector = snsCategory;
  else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobuttondate)))
    selector = snsDateRange;
  return selector;
}
