/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_INDEXER_H
#define INCLUDED_INDEXER_H


#include "libraries.h"
#include <glib.h>
#include "usfm.h"
#include "indexstorage.h"


class Indexer
{
public:
  Indexer (int dummy);
  virtual ~ Indexer ();
  virtual void start ();
  virtual void initialize_books (const ustring& project);
  virtual void update_chapter (const ustring& project, unsigned int book, unsigned int chapter, const vector <ustring> &lines);
  virtual void vacuum (const ustring& project);
  ustring dbfilename (const ustring& project);
  virtual void shutdown ();
  virtual bool is_ready ();
private:
  static void run_thread (gpointer data);
  virtual void run ();
  virtual void log (const ustring & message);
  static void check_book_thread (gpointer data);
  virtual void check_book ();
  static void index_chapter_thread (gpointer data);
  virtual void index_chapter ();
  virtual void delete_book (const ustring& project, unsigned int book);
  vector<IndexStorage> indexobjects;
  static void store_signature_thread (gpointer data);
  virtual void store_signature ();
  bool shutdown_flag;
};


#endif
