/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "layout.h"
#include "gtkwrappers.h"


void screen_layout_tools_area_set (bool current_pos, Configuration * configuration, 
                                   GtkWidget * parentleft, GtkWidget * parentright, 
                                   GtkWidget * childleft, GtkWidget * childright)
// Sets Tools Area left or right.
{
  // Current and desired position are the same: bail out.
  if (current_pos == configuration->tools_area_left)
    return;
  // Swap the left and right side.
  if (configuration->tools_area_left) {
    // Swapped
    gtk_widget_reparent (childleft, parentright);
    gtk_widget_reparent (childright, parentleft);
  } else {
    // Normal
    gtk_widget_reparent (childleft, parentleft);
    gtk_widget_reparent (childright, parentright);
  }
}


void screen_layout_vertical_pane_mirror (bool current_pos, Configuration * configuration, GtkWidget * pane)
// Mirrors the divisions of the main vertical pane, if need be.
{
  // Current and desired position are the same: bail out.
  if (current_pos == configuration->tools_area_left)
    return;
  int position = gtk_paned_get_position (GTK_PANED (pane));
  position = configuration->window_width - position;
  gtk_paned_set_position (GTK_PANED (pane), position);
}


void screen_layout_window_size_save (Configuration * configuration, GtkWidget * window)
{
  gtk_window_get_size (GTK_WINDOW (window), &configuration->window_width, &configuration->window_height);
  gtk_window_get_position (GTK_WINDOW (window), &configuration->window_x_position, &configuration->window_y_position);
}


void screen_layout_window_size_load (Configuration * configuration, GtkWidget * window)
{
  gtk_window_resize (GTK_WINDOW (window), configuration->window_width, configuration->window_height);
  gtk_window_move (GTK_WINDOW (window), configuration->window_x_position, configuration->window_y_position);
}


void screen_layout_panes_position_save (Configuration * configuration, 
     GtkWidget * hpane, GtkWidget * editor, GtkWidget * footnotes, GtkWidget * references)
{
  configuration->hpane_position = gtk_paned_get_position (GTK_PANED (hpane));
  configuration->vpane_editor_position = gtk_paned_get_position (GTK_PANED (editor));
  configuration->vpane_footnotes_position = gtk_paned_get_position (GTK_PANED (footnotes));
  configuration->vpane_references_position = gtk_paned_get_position (GTK_PANED (references));
}


void screen_layout_panes_position_load (Configuration * configuration, 
     GtkWidget * hpane, GtkWidget * editor, GtkWidget * footnotes, GtkWidget * references)
{
  gtk_paned_set_position (GTK_PANED (hpane), configuration->hpane_position);
  gtk_paned_set_position (GTK_PANED (editor), configuration->vpane_editor_position);
  gtk_paned_set_position (GTK_PANED (footnotes), configuration->vpane_footnotes_position);
  gtk_paned_set_position (GTK_PANED (references), configuration->vpane_references_position);
}
